/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.system;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.CollectLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollectorFactory;
import com.alibaba.csp.sentinel.command.system.SystemResourceType;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.system.SystemMetrics;
import com.alibaba.csp.sentinel.slots.system.metric.ContainerSystemMetricReader;
import com.alibaba.csp.sentinel.util.ContainerUtil;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class SystemIndexManager {
    private static final double rateFactor = TimeUnit.SECONDS.toSeconds(1L);
    private static final double durationFactor = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    private static final IMetricManager metricsManager = MetricManager.getIMetricManager();
    private static final List<String> metricGroups = new ArrayList<String>();
    public static final Map<String, Map<String, List<String>>> metricGroupIndexes = new HashMap<String, Map<String, List<String>>>();
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.00");
    private static final ContainerSystemMetricReader containerSystemMetricReader = new ContainerSystemMetricReader(1000);
    private static final Map<String, Long> gcInfo = new HashMap<String, Long>();

    private static void setJvmItems() {
        Pattern whiteSpace = Pattern.compile("[\\s]+");
        HashMap jvmIndexes = new HashMap();
        ArrayList<String> heapIndexes = new ArrayList<String>();
        List<MemoryPoolMXBean> memoryPools = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean pool : memoryPools) {
            String partName = whiteSpace.matcher(pool.getName()).replaceAll("_").toLowerCase();
            if (partName.equals("code_cache") || partName.equals("metaspace") || partName.equals("compressed_class_space")) continue;
            heapIndexes.add("jvm.mem.pools." + partName + ".used");
        }
        heapIndexes.add("jvm.mem.heap.used");
        jvmIndexes.put(SystemResourceType.JVM_HEAP.getName(), heapIndexes);
        ArrayList<String> metaIndexes = new ArrayList<String>();
        metaIndexes.add("jvm.mem.pools.metaspace.used");
        jvmIndexes.put(SystemResourceType.JVM_META.getName(), metaIndexes);
        ArrayList<String> noneHeapIndexes = new ArrayList<String>();
        noneHeapIndexes.add("jvm.mem.non_heap.committed");
        noneHeapIndexes.add("jvm.mem.non_heap.init");
        noneHeapIndexes.add("jvm.mem.non_heap.used");
        jvmIndexes.put(SystemResourceType.JVM_NONE_HEAP.getName(), noneHeapIndexes);
        ArrayList<String> directIndexes = new ArrayList<String>();
        directIndexes.add("jvm.buffer_pool.direct.used");
        directIndexes.add("jvm.buffer_pool.direct.capacity");
        jvmIndexes.put(SystemResourceType.JVM_DIRECT.getName(), directIndexes);
        ArrayList<String> threadCountIndexes = new ArrayList<String>();
        threadCountIndexes.add("jvm.thread.blocked.count");
        threadCountIndexes.add("jvm.thread.deadlock.count");
        threadCountIndexes.add("jvm.thread.new.count");
        threadCountIndexes.add("jvm.thread.runnable.count");
        threadCountIndexes.add("jvm.thread.terminated.count");
        threadCountIndexes.add("jvm.thread.timed_waiting.count");
        threadCountIndexes.add("jvm.thread.waiting.count");
        threadCountIndexes.add("jvm.thread.count");
        jvmIndexes.put(SystemResourceType.JVM_THREAD_COUNT.getName(), threadCountIndexes);
        ArrayList<String> gcIndexes = new ArrayList<String>();
        List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gc : beans) {
            String name = whiteSpace.matcher(gc.getName()).replaceAll("_").toLowerCase();
            gcIndexes.add("jvm.gc." + name + ".count");
            gcIndexes.add("jvm.gc." + name + ".time");
        }
        jvmIndexes.put(SystemResourceType.JVM_GC.getName(), gcIndexes);
        metricGroupIndexes.put(SystemResourceType.JVM.getName(), jvmIndexes);
    }

    private static void setSystemItems() {
        HashMap systemIndexes = new HashMap();
        ArrayList<String> systemCpuIndexes = new ArrayList<String>();
        systemCpuIndexes.add("system.cpu.user");
        systemCpuIndexes.add("system.cpu.system");
        systemCpuIndexes.add("system.cpu.iowait");
        systemIndexes.put(SystemResourceType.SYS_CPU.getName(), systemCpuIndexes);
        ArrayList<String> systemMemIndexes = new ArrayList<String>();
        systemMemIndexes.add("system.mem.buffers");
        systemMemIndexes.add("system.mem.cached");
        systemMemIndexes.add("system.mem.free");
        systemMemIndexes.add("system.mem.used");
        systemMemIndexes.add("system.mem.total");
        systemIndexes.put(SystemResourceType.SYS_MEM.getName(), systemMemIndexes);
        ArrayList<String> systemDiskIndexes = new ArrayList<String>();
        systemDiskIndexes.add("system.disk.partition.free");
        systemDiskIndexes.add("system.disk.partition.total");
        systemIndexes.put(SystemResourceType.SYS_DISK.getName(), systemDiskIndexes);
        ArrayList<String> systemLoadIndexes = new ArrayList<String>();
        systemLoadIndexes.add("system.load.1min");
        systemIndexes.put(SystemResourceType.SYS_LOAD.getName(), systemLoadIndexes);
        ArrayList<String> systemNetIndexes = new ArrayList<String>();
        systemNetIndexes.add("system.net.in.bytes");
        systemNetIndexes.add("system.net.out.bytes");
        systemNetIndexes.add("system.net.in.packets");
        systemNetIndexes.add("system.net.out.packets");
        systemNetIndexes.add("system.net.in.errs");
        systemNetIndexes.add("system.net.in.dropped");
        systemIndexes.put(SystemResourceType.SYS_NET.getName(), systemNetIndexes);
        metricGroupIndexes.put(SystemResourceType.SYSTEM.getName(), systemIndexes);
    }

    public static String getSystemIndexes(String metricName, String metricGroup, long time) {
        if (metricGroup == null) {
            return SystemIndexManager.geneSystemMetrics(SystemIndexManager.getMetricsParams(metricName), metricGroups, time);
        }
        return SystemIndexManager.geneSystemMetrics(SystemIndexManager.getMetricsParams(metricName), SystemIndexManager.getMetricsParams(metricGroup), time);
    }

    private static List<String> getMetricsParams(String origin) {
        if (StringUtils.isBlank(origin)) {
            return new ArrayList<String>(){
                private static final long serialVersionUID = 1L;
                {
                    this.add("system_cpu");
                    this.add("system_memory");
                    this.add("system_disk");
                    this.add("system_load");
                    this.add("system_network");
                    this.add("jvm_heap");
                    this.add("jvm_meta_space");
                    this.add("jvm_direct");
                    this.add("jvm_none_heap");
                    this.add("jvm_thread_count");
                    this.add("jvm_gc");
                }
            };
        }
        return new ArrayList<String>(Arrays.asList(origin.split(",")));
    }

    private static String geneSystemMetrics(List<String> metricNames, List<String> metricGroups, long time) {
        Map<String, List<String>> fetchMetrics = SystemIndexManager.geneMetrics(metricNames);
        StringBuilder builder = new StringBuilder();
        builder.append(time).append("|");
        for (String group : metricGroups) {
            try {
                MetricRegistry registry = metricsManager.getMetricRegistryByGroup(group);
                Map<String, MetricObject> metrics = SystemIndexManager.getSystemMetrics(registry);
                if (metrics.size() == 0) continue;
                List<String> innerMetricNames = fetchMetrics.get(group);
                for (String innerMetricName : innerMetricNames) {
                    MetricObject metric;
                    List<String> indexes;
                    if ("system_cpu".equals(innerMetricName)) {
                        if (ContainerUtil.isRunningInContainer() && containerSystemMetricReader.getCurrentCpuUsage() >= 0.0) {
                            builder.append(0.0).append("|").append(0.0).append("|").append(0.0).append("|");
                            builder.append(decimalFormat.format(containerSystemMetricReader.getCurrentCpuUsage())).append("|");
                            continue;
                        }
                        indexes = metricGroupIndexes.get(group).get(innerMetricName);
                        double total = 0.0;
                        for (String index : indexes) {
                            MetricObject metric2 = metrics.get(index);
                            Number value = (Number)metric2.getValue();
                            if (value != null) {
                                total += value.doubleValue();
                                builder.append(value);
                            }
                            builder.append("|");
                        }
                        builder.append(decimalFormat.format(total)).append("|");
                        continue;
                    }
                    if ("system_disk".equals(innerMetricName)) {
                        MetricObject freeMetric = metrics.get("system.disk.partition.free");
                        double free = ((Number)freeMetric.getValue()).doubleValue() / 1.0E9;
                        MetricObject totalMetric = metrics.get("system.disk.partition.total");
                        double total = ((Number)totalMetric.getValue()).doubleValue() / 1.0E9;
                        builder.append(decimalFormat.format(free)).append("|").append(decimalFormat.format(total - free)).append("|").append(decimalFormat.format(total)).append("|");
                        continue;
                    }
                    if ("system_load".equals(innerMetricName)) {
                        if (ContainerUtil.isRunningInContainer()) {
                            builder.append(SystemMetrics.getCurrentSystemLoad()).append("|");
                            continue;
                        }
                        indexes = metricGroupIndexes.get(group).get(innerMetricName);
                        for (String index : indexes) {
                            metric = metrics.get(index);
                            Number value = (Number)metric.getValue();
                            if (value != null) {
                                builder.append(value);
                            }
                            builder.append("|");
                        }
                        continue;
                    }
                    if ("system_network".equals(innerMetricName)) {
                        indexes = metricGroupIndexes.get(group).get(innerMetricName);
                        for (String index : indexes) {
                            metric = metrics.get(index);
                            if (metric == null) {
                                builder.append(0.0).append("|");
                                continue;
                            }
                            Number value = (Number)metric.getValue();
                            if (value != null) {
                                builder.append(decimalFormat.format(value.doubleValue()));
                            }
                            builder.append("|");
                        }
                        continue;
                    }
                    if ("jvm_thread_count".equals(innerMetricName)) {
                        indexes = metricGroupIndexes.get(group).get(innerMetricName);
                        for (String index : indexes) {
                            metric = metrics.get(index);
                            Number value = (Number)metric.getValue();
                            if (value != null) {
                                builder.append(value);
                            }
                            builder.append("|");
                        }
                        continue;
                    }
                    if ("jvm_gc".equals(innerMetricName)) {
                        indexes = metricGroupIndexes.get(group).get(innerMetricName);
                        for (String index : indexes) {
                            metric = metrics.get(index);
                            if (metric == null) {
                                builder.append(0).append("|");
                                continue;
                            }
                            Number value = (Number)metric.getValue();
                            if (value != null) {
                                Long preVal = gcInfo.get(index);
                                if (preVal == null) {
                                    preVal = 0L;
                                }
                                long curVal = value.longValue();
                                builder.append(curVal - preVal);
                                gcInfo.put(index, curVal);
                            }
                            builder.append("|");
                        }
                        continue;
                    }
                    indexes = metricGroupIndexes.get(group).get(innerMetricName);
                    for (String index : indexes) {
                        metric = metrics.get(index);
                        if (metric == null) {
                            builder.append(0.0).append("|");
                            continue;
                        }
                        Number value = (Number)metric.getValue();
                        if (value != null) {
                            double val = value.doubleValue() / 1000000.0;
                            builder.append(decimalFormat.format(val));
                        }
                        builder.append("|");
                    }
                }
            }
            catch (Throwable e) {
                RecordLog.warn("[SystemIndexManager] WARN: Failed to get metrics, group=" + group, e);
            }
        }
        String preRes = builder.toString();
        return preRes.substring(0, preRes.lastIndexOf("|"));
    }

    private static Map<String, List<String>> geneMetrics(List<String> metricNames) {
        HashMap<String, List<String>> metrics = new HashMap<String, List<String>>();
        if (metricNames == null || metricNames.size() == 0) {
            return metrics;
        }
        for (String metricName : metricNames) {
            String metric = metricName.split("_")[0];
            ArrayList<String> indexes = (ArrayList<String>)metrics.get(metric);
            if (indexes == null) {
                indexes = new ArrayList<String>();
            }
            indexes.add(metricName);
            metrics.put(metric, indexes);
        }
        return metrics;
    }

    private static Map<String, MetricObject> getSystemMetrics(MetricRegistry registry) {
        return SystemIndexManager.getSystemMetrics(registry, null);
    }

    private static Map<String, MetricObject> getSystemMetrics(MetricRegistry registry, MetricFilter filter) {
        long ts = System.currentTimeMillis();
        MetricsCollector collector = MetricsCollectorFactory.createNew(CollectLevel.NORMAL, rateFactor, durationFactor, filter);
        SortedMap<MetricName, Gauge> gauges = filter == null ? registry.getGauges() : registry.getGauges(filter);
        for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        HashMap<String, MetricObject> systemMetrics = new HashMap<String, MetricObject>();
        List<MetricObject> metricObjects = collector.build();
        for (MetricObject cur : metricObjects) {
            systemMetrics.put(cur.getMetric(), cur);
        }
        return systemMetrics;
    }

    static {
        try {
            metricGroups.add(SystemResourceType.SYSTEM.getName());
            metricGroups.add(SystemResourceType.JVM.getName());
            SystemIndexManager.setSystemItems();
            SystemIndexManager.setJvmItems();
        }
        catch (Throwable e) {
            RecordLog.warn("[SystemIndexManager] Failed to set system items with exception", e);
        }
    }
}

