/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.system;

import com.alibaba.csp.sentinel.command.system.reader.ISystemMetricsReader;
import com.alibaba.csp.sentinel.command.system.reader.SystemMetricsReaderFactory;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class SystemMetricsManager {
    private static volatile SystemMetricsManager systemMetricsManager;
    private final Map<String, List<String>> metricIndexes;
    private final List<String> groups = new ArrayList<String>();
    private static final Pattern WHITE_SPACE;

    private SystemMetricsManager() {
        this.metricIndexes = this.readLinesFromFile("metrics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemMetricsManager getInstance() {
        if (systemMetricsManager != null) return systemMetricsManager;
        Class<SystemMetricsManager> clazz = SystemMetricsManager.class;
        synchronized (SystemMetricsManager.class) {
            if (systemMetricsManager != null) return systemMetricsManager;
            systemMetricsManager = new SystemMetricsManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return systemMetricsManager;
        }
    }

    public String getSystemIndexes(List<String> metrics, long time) {
        ISystemMetricsReader iSystemMetricsReader = SystemMetricsReaderFactory.getInstance().getSystemMetricsReader();
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(time).append("|");
            for (String key : this.groups) {
                List<String> innerMetricNames = this.metricIndexes.get(key);
                for (String innerMetricName : innerMetricNames) {
                    double val = iSystemMetricsReader.getMetricWithId(key, innerMetricName);
                    builder.append(val).append("|");
                }
            }
            for (String metric : metrics) {
                if (!metric.contains(".")) continue;
                double val = iSystemMetricsReader.getMetricWithId(metric.split("\\.")[0], metric);
                builder.append(val).append("|");
            }
            return builder.substring(0, builder.lastIndexOf("|"));
        }
        catch (Throwable e) {
            RecordLog.warn("[SystemMetricsManager] WARN: Failed to get metrics:{} , group {} ", metrics, e);
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> readLinesFromFile(String filePath) {
        HashMap<String, List<String>> lines = new HashMap<String, List<String>>();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(filePath);
        if (inputStream == null) {
            return lines;
        }
        BufferedReader reader = null;
        try {
            String lineTxt;
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String outGroup = "";
            while ((lineTxt = reader.readLine()) != null) {
                ArrayList<String> inLines;
                if (lineTxt.startsWith("#")) continue;
                String group = lineTxt.split("\\.")[0];
                if (!outGroup.equals(group)) {
                    outGroup = group;
                    this.groups.add(group);
                }
                if ((inLines = (ArrayList<String>)lines.get(group)) == null) {
                    inLines = new ArrayList<String>();
                }
                if (lineTxt.startsWith("jvm.mem.pools")) {
                    String name = lineTxt.split("\\.")[3];
                    List<MemoryPoolMXBean> memoryPools = ManagementFactory.getMemoryPoolMXBeans();
                    for (MemoryPoolMXBean pool : memoryPools) {
                        String partName = WHITE_SPACE.matcher(pool.getName()).replaceAll("_").toLowerCase();
                        if (!partName.endsWith(name)) continue;
                        lineTxt = lineTxt.replace(name, partName);
                    }
                }
                if (lineTxt.startsWith("jvm.gc")) {
                    String generation = lineTxt.split("\\.")[2];
                    List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
                    for (GarbageCollectorMXBean gc : beans) {
                        String name = WHITE_SPACE.matcher(gc.getName()).replaceAll("_").toLowerCase();
                        if ("young".equals(generation) && ("parnew".equals(name) || "ps_scavenge".equals(name) || name.equals("g1_young_generation") || name.equals("copy"))) {
                            lineTxt = lineTxt.replace(generation, name);
                        }
                        if (!"old".equals(generation) || !"concurrentmarksweep".equals(name) && !"ps_marksweep".equals(name) && !"marksweepcompact".equals(name) && !"g1_old_generation".equals(name)) continue;
                        lineTxt = lineTxt.replace(generation, name);
                    }
                }
                inLines.add(lineTxt);
                lines.put(group, inLines);
            }
        }
        catch (Exception ex) {
            RecordLog.warn("[ContainerSystemMetricReader] Failed to read cgroup file: " + filePath, ex);
            Map<String, List<String>> map = null;
            return map;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    RecordLog.warn("[ContainerSystemMetricReader] Failed to close reader " + filePath, e);
                }
            }
            try {
                inputStream.close();
            }
            catch (Exception e) {
                RecordLog.warn("[ContainerSystemMetricReader] Failed to close inputStream " + filePath, e);
            }
        }
        return lines;
    }

    static {
        WHITE_SPACE = Pattern.compile("[\\s]+");
    }
}

