/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.system.reader;

import com.alibaba.csp.sentinel.command.system.reader.HostSystemMetricsReader;
import com.alibaba.csp.sentinel.command.system.reader.ISystemMetricsReader;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ContainerSystemMetricsReader
implements ISystemMetricsReader {
    private static final String CGROUP_CPUACCT_USAGE_DIR = "/sys/fs/cgroup/cpuacct/cpuacct.usage";
    private static final String CGROUP_CPUACCT_USAGE_USR_SYS_DIR = "/sys/fs/cgroup/cpuacct/cpuacct.stat";
    private static final String CGROUP_CPUACCT_USAGE_USR_DIR = "/sys/fs/cgroup/cpuacct/cpuacct.usage_user";
    private static final String CGROUP_CPUACCT_USAGE_SYS_DIR = "/sys/fs/cgroup/cpuacct/cpuacct.usage_sys";
    private static final String CGROUP_CPU_SHARE_DIR = "/sys/fs/cgroup/cpu/cpu.shares";
    private static final String CGROUP_CPU_QUOTA_DIR = "/sys/fs/cgroup/cpu/cpu.cfs_quota_us";
    private static final String CGROUP_CPU_PERIOD_DIR = "/sys/fs/cgroup/cpu/cpu.cfs_period_us";
    private static final String CGROUP_CPUACCT_MEM_LIMIT_DIR = "/sys/fs/cgroup/memory/memory.limit_in_bytes";
    private static final String CGROUP_CPUACCT_MEM_USAGE_DIR = "/sys/fs/cgroup/memory/memory.usage_in_bytes";
    private static final String CGROUP_CPUACCT_MEM_STATE_DIR = "/sys/fs/cgroup/memory/memory.stat";
    private static String CGROUP_NET_RX_BYTES;
    private static String CGROUP_NET_TX_BYTES;
    private static String CGROUP_NET_RX_PACKETS;
    private static String CGROUP_NET_TX_PACKETS;
    private static String CGROUP_NET_RX_DROPPED;
    private static String CGROUP_NET_RX_ERRS;
    private static boolean cgroupCpuAcctUserExists;
    private static final Map<String, Long> NET_METRICS;
    private static final Map<String, String> NET_METRIC_TAGS;
    private double cpuCores = -1.0;
    private double tickPerMillis = -1.0;
    private volatile double curCpuUsage = -1.0;
    private long prevCpuTotal = -1L;
    private volatile double curCpuUsageUser = -1.0;
    private long prevCpuUser = -1L;
    private volatile double curCpuUsageSys = -1.0;
    private long prevCpuSys = -1L;
    private final int periodMs;
    private final ExecutorService collectorTask = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new NamedThreadFactory("container-metrics-collector-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final HostSystemMetricsReader hostSystemMetricsReader = new HostSystemMetricsReader();

    public ContainerSystemMetricsReader(int periodMs) {
        this.periodMs = periodMs;
        NET_METRIC_TAGS.put("system.net.in.bytes", CGROUP_NET_RX_BYTES);
        NET_METRIC_TAGS.put("system.net.out.bytes", CGROUP_NET_TX_BYTES);
        NET_METRIC_TAGS.put("system.net.in.packets", CGROUP_NET_RX_PACKETS);
        NET_METRIC_TAGS.put("system.net.out.packets", CGROUP_NET_TX_PACKETS);
        NET_METRIC_TAGS.put("system.net.in.dropped", CGROUP_NET_RX_DROPPED);
        NET_METRIC_TAGS.put("system.net.in.errs", CGROUP_NET_RX_ERRS);
    }

    @Override
    public void init() {
        long cpuPeriod = this.readLongFromFile(CGROUP_CPU_PERIOD_DIR);
        long cpuQuota = this.readLongFromFile(CGROUP_CPU_QUOTA_DIR);
        long cpuShares = this.readLongFromFile(CGROUP_CPU_SHARE_DIR);
        if (cpuQuota > 0L && cpuPeriod > 0L) {
            this.cpuCores = (double)cpuQuota * 1.0 / (double)cpuPeriod;
        } else if (cpuShares > 0L) {
            this.cpuCores = (double)cpuShares * 1.0 / 1024.0;
        }
        if (this.cpuCores > 0.0) {
            this.tickPerMillis = this.cpuCores * 1000.0 * 1000.0;
            this.collectorTask.submit(new Runnable(){

                @Override
                public void run() {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    try {
                        ContainerSystemMetricsReader.this.loopCollect();
                    }
                    catch (Throwable e) {
                        RecordLog.warn("[ContainerSystemMetricCollectorTask] Failed to start sentinel-container-system-metric-collector", e);
                    }
                }
            });
        }
    }

    @Override
    public double getMetricWithId(String group, String metric) {
        if ("system".equals(group)) {
            if ("system.cpu.user".equals(metric)) {
                return this.getCurrentCpuUserUsage();
            }
            if ("system.cpu.system".equals(metric)) {
                return this.getCurrentCpuSysUsage();
            }
            if ("system.cpu.total".equals(metric)) {
                return this.getCurrentCpuUsage();
            }
            if (metric.startsWith("system.net")) {
                return this.getNetMetric(metric, group);
            }
        }
        return this.hostSystemMetricsReader.getMetricWithId(group, metric);
    }

    public double getNetMetric(String metric, String group) {
        Long preVal = NET_METRICS.get(metric);
        long val = this.readLongFromFile(NET_METRIC_TAGS.get(metric));
        if (preVal == null) {
            NET_METRICS.put(metric, val);
            return 0.0;
        }
        double res = val - preVal;
        NET_METRICS.put(metric, val);
        return res;
    }

    public double getCurrentCpuUsage() {
        return this.curCpuUsage;
    }

    public double getCurrentCpuSysUsage() {
        return this.curCpuUsageSys;
    }

    public double getCurrentCpuUserUsage() {
        return this.curCpuUsageUser;
    }

    public double getCurrentMemUsed() {
        long usage = this.readLongFromFile(CGROUP_CPUACCT_MEM_USAGE_DIR);
        long rss = ContainerSystemMetricsReader.readSpecificLineFromFile(CGROUP_CPUACCT_MEM_STATE_DIR, "rss");
        long active = ContainerSystemMetricsReader.readSpecificLineFromFile(CGROUP_CPUACCT_MEM_STATE_DIR, "active_file");
        long inactive = ContainerSystemMetricsReader.readSpecificLineFromFile(CGROUP_CPUACCT_MEM_STATE_DIR, "inactive_file");
        return (double)(usage - inactive) / 1000000.0;
    }

    public double getCurrentMemCache() {
        return (double)ContainerSystemMetricsReader.readSpecificLineFromFile(CGROUP_CPUACCT_MEM_STATE_DIR, "cache") / 1000000.0;
    }

    public double getCurrentMemTotal() {
        return (double)this.readLongFromFile(CGROUP_CPUACCT_MEM_LIMIT_DIR) / 1000000.0;
    }

    public double getCurrentMemFree() {
        return this.getCurrentMemTotal() - this.getCurrentMemUsed();
    }

    private void loopCollect() {
        while (true) {
            try {
                this.retrieveAndUpdateSystemStat();
            }
            catch (Throwable e) {
                RecordLog.warn("[ContainerSystemMetricCollectorTask] Failed to get and update container system metrics", e);
            }
            ContainerSystemMetricsReader.sleepMs(this.periodMs);
        }
    }

    private void retrieveAndUpdateSystemStat() {
        this.calculateCpuTotal();
        this.calculateCpuUser();
        this.calculateCpuSys();
    }

    private void calculateCpuTotal() {
        long curCgroupCpuAcctUsage = this.getCgroupCpuAcctUsage();
        if (curCgroupCpuAcctUsage < 0L) {
            return;
        }
        if (this.prevCpuTotal > 0L) {
            double tick = this.tickPerMillis * (double)this.periodMs;
            double percentage = 100.0 * Math.max(0.0, (double)(curCgroupCpuAcctUsage - this.prevCpuTotal) / tick);
            this.curCpuUsage = Math.min(percentage, 100.0);
            if (this.curCpuUsage < 4.0E-4) {
                this.curCpuUsage = 0.0;
            }
        }
        this.prevCpuTotal = curCgroupCpuAcctUsage;
    }

    private void calculateCpuUser() {
        long curCgroupCpuAcctUsage = this.getCgroupCpuAcctUerUsage();
        if (curCgroupCpuAcctUsage < 0L) {
            return;
        }
        if (this.prevCpuUser > 0L) {
            double tick = cgroupCpuAcctUserExists ? this.tickPerMillis * (double)this.periodMs : (double)this.periodMs;
            double percentage = 100.0 * Math.max(0.0, (double)(curCgroupCpuAcctUsage - this.prevCpuUser) / tick);
            this.curCpuUsageUser = Math.min(percentage, 100.0);
            if (this.curCpuUsageUser < 4.0E-4) {
                this.curCpuUsageUser = 0.0;
            }
        }
        this.prevCpuUser = curCgroupCpuAcctUsage;
    }

    private void calculateCpuSys() {
        long curCgroupCpuAcctUsage = this.getCgroupCpuAcctSysUsage();
        if (curCgroupCpuAcctUsage < 0L) {
            return;
        }
        if (this.prevCpuSys > 0L) {
            double tick = cgroupCpuAcctUserExists ? this.tickPerMillis * (double)this.periodMs : (double)this.periodMs;
            double percentage = 100.0 * Math.max(0.0, (double)(curCgroupCpuAcctUsage - this.prevCpuSys) / tick);
            this.curCpuUsageSys = Math.min(percentage, 100.0);
            if (this.curCpuUsageSys < 4.0E-4) {
                this.curCpuUsageSys = 0.0;
            }
        }
        this.prevCpuSys = curCgroupCpuAcctUsage;
    }

    private long getCgroupCpuAcctUerUsage() {
        return cgroupCpuAcctUserExists ? this.readLongFromFile(CGROUP_CPUACCT_USAGE_USR_DIR) : ContainerSystemMetricsReader.readSpecificLineFromFile(CGROUP_CPUACCT_USAGE_USR_SYS_DIR, "user");
    }

    private long getCgroupCpuAcctSysUsage() {
        return cgroupCpuAcctUserExists ? this.readLongFromFile(CGROUP_CPUACCT_USAGE_SYS_DIR) : ContainerSystemMetricsReader.readSpecificLineFromFile(CGROUP_CPUACCT_USAGE_USR_SYS_DIR, "system");
    }

    private long getCgroupCpuAcctUsage() {
        return this.readLongFromFile(CGROUP_CPUACCT_USAGE_DIR);
    }

    private long readLongFromFile(String path) {
        try {
            String v = ContainerSystemMetricsReader.readSingleLineFromFile(path);
            if (StringUtil.isBlank(v)) {
                return -1L;
            }
            return Long.parseLong(v);
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readSingleLineFromFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String string = reader.readLine();
            return string;
        }
        catch (Exception ex) {
            RecordLog.warn("[ContainerSystemMetricReader] Failed to read cgroup file: " + filePath, ex);
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    RecordLog.warn("[ContainerSystemMetricReader] Failed to close reader " + filePath, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readSpecificLineFromFile(String filePath, String name) {
        File file = new File(filePath);
        if (!file.exists()) {
            return -1L;
        }
        BufferedReader reader = null;
        try {
            String lineTxt;
            reader = new BufferedReader(new FileReader(file));
            while ((lineTxt = reader.readLine()) != null) {
                String[] kv = lineTxt.split(" ");
                if (!name.equals(kv[0])) continue;
                long l = Long.parseLong(kv[1]);
                return l;
            }
        }
        catch (Exception ex) {
            RecordLog.warn("[ContainerSystemMetricReader] Failed to read cgroup stat file: " + filePath, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    RecordLog.warn("[ContainerSystemMetricReader] Failed to close reader " + filePath, e);
                }
            }
        }
        return -1L;
    }

    private static void sleepMs(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            String netName = "eth0";
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface next = networkInterfaces.nextElement();
                if (!next.getName().startsWith("eth")) continue;
                netName = next.getName();
            }
            CGROUP_NET_RX_BYTES = "/sys/class/net/" + netName + "/statistics/rx_bytes";
            CGROUP_NET_TX_BYTES = "/sys/class/net/" + netName + "/statistics/tx_bytes";
            CGROUP_NET_RX_PACKETS = "/sys/class/net/" + netName + "/statistics/rx_packets";
            CGROUP_NET_TX_PACKETS = "/sys/class/net/" + netName + "/statistics/tx_packets";
            CGROUP_NET_RX_DROPPED = "/sys/class/net/" + netName + "/statistics/rx_dropped";
            CGROUP_NET_RX_ERRS = "/sys/class/net/" + netName + "/statistics/rx_errors";
            cgroupCpuAcctUserExists = new File(CGROUP_CPUACCT_USAGE_USR_DIR).exists();
        }
        catch (SocketException s) {
            RecordLog.warn("[CONTAINER-SYSTEM-READER] failed to load net service", s);
        }
        NET_METRICS = new ConcurrentHashMap<String, Long>();
        NET_METRIC_TAGS = new ConcurrentHashMap<String, String>();
    }
}

