/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.system.reader;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.IMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.CollectLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollector;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricsCollectorFactory;
import com.alibaba.csp.sentinel.command.system.reader.ISystemMetricsReader;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class HostSystemMetricsReader
implements ISystemMetricsReader {
    private static final double RATE_FACTOR = TimeUnit.SECONDS.toSeconds(1L);
    private static final double DURATION_FACTOR = 1.0 / (double)TimeUnit.MILLISECONDS.toNanos(1L);
    private static final IMetricManager metricsManager = MetricManager.getIMetricManager();
    private static final Map<String, Long> gcInfo = new ConcurrentHashMap<String, Long>();

    @Override
    public void init() {
    }

    @Override
    public double getMetricWithId(String group, String metric) {
        try {
            MetricRegistry registry = metricsManager.getMetricRegistryByGroup(group);
            Map<String, List<MetricObject>> metricObjects = HostSystemMetricsReader.getSystemMetrics(registry, null);
            List<MetricObject> metrics = metricObjects.get(metric);
            if (metrics == null || metric.isEmpty()) {
                return 0.0;
            }
            double origin = 0.0;
            long gc = 0L;
            for (MetricObject metricObject : metrics) {
                Number value = (Number)metricObject.getValue();
                if (value == null) continue;
                origin += value.doubleValue();
                if (!metric.startsWith("jvm.gc.")) continue;
                gc += value.longValue();
            }
            if (metric.startsWith("system.disk.")) {
                origin /= 1.0E9;
            } else if (metric.startsWith("jvm.gc.")) {
                Long preVal = gcInfo.get(metric);
                if (preVal == null) {
                    preVal = 0L;
                }
                origin = gc - preVal;
                gcInfo.put(metric, gc);
            } else if (metric.contains(".mem.")) {
                origin /= 1000000.0;
            }
            return this.round2Deci(origin);
        }
        catch (Throwable e) {
            RecordLog.warn("[HostSystemMetricsReader] WARN: failed to get metric with id ", e);
            return 0.0;
        }
    }

    private double round2Deci(double origin) {
        return (double)((int)(origin * 100.0)) / 100.0;
    }

    private static Map<String, List<MetricObject>> getSystemMetrics(MetricRegistry registry, MetricFilter filter) {
        long ts = System.currentTimeMillis();
        MetricsCollector collector = MetricsCollectorFactory.createNew(CollectLevel.NORMAL, RATE_FACTOR, DURATION_FACTOR, filter);
        SortedMap<MetricName, Gauge> gauges = filter == null ? registry.getGauges() : registry.getGauges(filter);
        for (Map.Entry<MetricName, Gauge> entry : gauges.entrySet()) {
            collector.collect(entry.getKey(), entry.getValue(), ts);
        }
        HashMap<String, List<MetricObject>> systemMetrics = new HashMap<String, List<MetricObject>>();
        List<MetricObject> metricObjects = collector.build();
        for (MetricObject cur : metricObjects) {
            ArrayList<MetricObject> inners = (ArrayList<MetricObject>)systemMetrics.get(cur.getMetric());
            if (inners == null) {
                inners = new ArrayList<MetricObject>(2);
            }
            inners.add(cur);
            systemMetrics.put(cur.getMetric(), inners);
        }
        return systemMetrics;
    }
}

