/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource;

import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileInJarReadableDataSource<T>
extends AbstractDataSource<String, T> {
    private static final int MAX_SIZE = 0x400000;
    private static final int DEFAULT_BUF_SIZE = 0x100000;
    private static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    private final Charset charset;
    private final String jarName;
    private final String fileInJarName;
    private byte[] buf;
    private JarEntry jarEntry;
    private JarFile jarFile;

    public FileInJarReadableDataSource(String jarName, String fileInJarName, Converter<String, T> configParser) throws IOException {
        this(jarName, fileInJarName, configParser, 0x100000, DEFAULT_CHARSET);
    }

    public FileInJarReadableDataSource(String jarName, String fileInJarName, Converter<String, T> configParser, int bufSize) throws IOException {
        this(jarName, fileInJarName, configParser, bufSize, DEFAULT_CHARSET);
    }

    public FileInJarReadableDataSource(String jarName, String fileInJarName, Converter<String, T> configParser, Charset charset) throws IOException {
        this(jarName, fileInJarName, configParser, 0x100000, charset);
    }

    public FileInJarReadableDataSource(String jarName, String fileInJarName, Converter<String, T> configParser, int bufSize, Charset charset) throws IOException {
        super(configParser);
        AssertUtil.assertNotBlank(jarName, "jarName cannot be blank");
        AssertUtil.assertNotBlank(fileInJarName, "fileInJarName cannot be blank");
        if (bufSize <= 0 || bufSize > 0x400000) {
            throw new IllegalArgumentException("bufSize must between (0, 4194304], but " + bufSize + " get");
        }
        AssertUtil.notNull(charset, "charset can't be null");
        this.buf = new byte[bufSize];
        this.charset = charset;
        this.jarName = jarName;
        this.fileInJarName = fileInJarName;
        this.initializeJar();
        this.firstLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readSource() throws Exception {
        if (null == this.jarEntry) {
            RecordLog.warn(String.format("[FileInJarReadableDataSource] File does not exist: %s", this.jarFile.getName()), new Object[0]);
        }
        InputStream inputStream = null;
        try {
            inputStream = this.jarFile.getInputStream(this.jarEntry);
            if (inputStream.available() > this.buf.length) {
                throw new IllegalStateException(String.format("Size of file <%s> exceeds the bufSize (%d): %d", this.jarFile.getName(), this.buf.length, inputStream.available()));
            }
            int len = inputStream.read(this.buf);
            String string = new String(this.buf, 0, len, this.charset);
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void firstLoad() {
        try {
            Object newValue = this.loadConfig();
            this.getProperty().updateValue(newValue);
        }
        catch (Throwable e) {
            RecordLog.warn("[FileInJarReadableDataSource] Error when loading config", e);
        }
    }

    @Override
    public void close() throws Exception {
        this.buf = null;
    }

    private void initializeJar() throws IOException {
        this.jarFile = new JarFile(this.jarName);
        this.jarEntry = this.jarFile.getJarEntry(this.fileInJarName);
    }
}

