/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource;

import com.alibaba.csp.sentinel.datasource.AutoRefreshDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

public class FileRefreshableDataSource<T>
extends AutoRefreshDataSource<String, T> {
    private static final int MAX_SIZE = 0x400000;
    private static final long DEFAULT_REFRESH_MS = 3000L;
    private static final int DEFAULT_BUF_SIZE = 0x100000;
    private static final Charset DEFAULT_CHAR_SET = Charset.forName("utf-8");
    private byte[] buf;
    private final Charset charset;
    private final File file;
    private long lastModified = 0L;

    public FileRefreshableDataSource(File file, Converter<String, T> configParser) throws FileNotFoundException {
        this(file, configParser, 3000L, 0x100000, DEFAULT_CHAR_SET);
    }

    public FileRefreshableDataSource(String fileName, Converter<String, T> configParser) throws FileNotFoundException {
        this(new File(fileName), configParser, 3000L, 0x100000, DEFAULT_CHAR_SET);
    }

    public FileRefreshableDataSource(File file, Converter<String, T> configParser, int bufSize) throws FileNotFoundException {
        this(file, configParser, 3000L, bufSize, DEFAULT_CHAR_SET);
    }

    public FileRefreshableDataSource(File file, Converter<String, T> configParser, Charset charset) throws FileNotFoundException {
        this(file, configParser, 3000L, 0x100000, charset);
    }

    public FileRefreshableDataSource(File file, Converter<String, T> configParser, long recommendRefreshMs, int bufSize, Charset charset) throws FileNotFoundException {
        super(configParser, recommendRefreshMs);
        if (bufSize <= 0 || bufSize > 0x400000) {
            throw new IllegalArgumentException("bufSize must between (0, 4194304], but " + bufSize + " get");
        }
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException("File can't be null or a directory");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset can't be null");
        }
        this.buf = new byte[bufSize];
        this.file = file;
        this.charset = charset;
        this.lastModified = file.lastModified();
        this.firstLoad();
    }

    private void firstLoad() {
        try {
            Object newValue = this.loadConfig();
            this.getProperty().updateValue(newValue);
        }
        catch (Throwable e) {
            RecordLog.info("loadConfig exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readSource() throws Exception {
        if (!this.file.exists()) {
            RecordLog.warn(String.format("[FileRefreshableDataSource] File does not exist: %s", this.file.getAbsolutePath()), new Object[0]);
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.file);
            FileChannel channel = inputStream.getChannel();
            if (channel.size() > (long)this.buf.length) {
                throw new IllegalStateException(this.file.getAbsolutePath() + " file size=" + channel.size() + ", is bigger than bufSize=" + this.buf.length + ". Can't read");
            }
            int len = inputStream.read(this.buf);
            String string = new String(this.buf, 0, len, this.charset);
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected boolean isModified() {
        long curLastModified = this.file.lastModified();
        if (curLastModified != this.lastModified) {
            this.lastModified = curLastModified;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.buf = null;
    }
}

