/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.init;

import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.ServiceLoaderUtil;
import com.alibaba.csp.sentinel.util.SpiLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class InitExecutor {
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    public static void doInit() {
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        Class<InitFunc> initFuncClazz = InitFunc.class;
        try {
            ClassLoader targetClassLoader = ServiceLoaderUtil.getTargetClassLoader(initFuncClazz);
            Map<String, Class<?>> initFuncImplMap = ServiceLoaderUtil.findImplClasses(initFuncClazz, targetClassLoader);
            RecordLog.info("[InitExecutor] Found init func: {}, classLoader={}", initFuncImplMap.keySet(), targetClassLoader);
            ClassLoader appContextClassLoader = ServiceLoaderUtil.getAppContextClassLoader();
            if (appContextClassLoader != null && appContextClassLoader != initFuncClazz.getClassLoader()) {
                Map<String, Class<?>> mapOfAccl = ServiceLoaderUtil.findImplClasses(initFuncClazz, appContextClassLoader, SpiLoader.SENTINEL_INTERNAL_PACKAGE_SET);
                RecordLog.info("[InitExecutor] Found init func from appContextClassLoader {}: {}", appContextClassLoader, mapOfAccl.keySet());
                initFuncImplMap.putAll(mapOfAccl);
            }
            ArrayList<OrderWrapper> initList = new ArrayList<OrderWrapper>();
            for (Map.Entry<String, Class<?>> e : initFuncImplMap.entrySet()) {
                InitFunc initFunc = (InitFunc)initFuncClazz.cast(e.getValue().newInstance());
                InitExecutor.insertSorted(initList, initFunc);
            }
            for (OrderWrapper w : initList) {
                w.func.init();
                RecordLog.info("[InitExecutor] Executing {} with order {}", w.func.getClass().getCanonicalName(), w.order);
            }
        }
        catch (Exception ex) {
            RecordLog.error("[InitExecutor] Initialization failed", ex);
            ex.printStackTrace();
        }
        catch (Error error) {
            RecordLog.error("[InitExecutor] Initialization failed with fatal error", error);
            error.printStackTrace();
        }
    }

    public static boolean isInitialized() {
        return initialized.get();
    }

    private static void insertSorted(List<OrderWrapper> list, InitFunc func) {
        int idx;
        int order = InitExecutor.resolveOrder(func);
        for (idx = 0; idx < list.size() && list.get(idx).getOrder() <= order; ++idx) {
        }
        list.add(idx, new OrderWrapper(order, func));
    }

    private static int resolveOrder(InitFunc func) {
        if (!func.getClass().isAnnotationPresent(InitOrder.class)) {
            return Integer.MAX_VALUE;
        }
        return func.getClass().getAnnotation(InitOrder.class).value();
    }

    private InitExecutor() {
    }

    private static class OrderWrapper {
        private final int order;
        private final InitFunc func;

        OrderWrapper(int order, InitFunc func) {
            this.order = order;
            this.func = func;
        }

        int getOrder() {
            return this.order;
        }

        InitFunc getFunc() {
            return this.func;
        }
    }
}

