/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.metric.extension.callback;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import com.alibaba.csp.sentinel.metric.extension.MetricExtensionProvider;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotExitCallback;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.util.TimeUtil;

public class MetricExitCallback
implements ProcessorSlotExitCallback {
    @Override
    public void onExit(Context context, ResourceWrapper rw, int acquireCount, Object ... args) {
        Entry curEntry = context.getCurEntry();
        if (curEntry == null) {
            return;
        }
        for (MetricExtension m : MetricExtensionProvider.getMetricExtensions()) {
            if (curEntry.getBlockError() != null) continue;
            long completeTime = curEntry.getCompleteTimestamp();
            if (completeTime <= 0L) {
                completeTime = TimeUtil.currentTimeMillis();
            }
            long rt = completeTime - curEntry.getCreateTimestamp();
            m.onComplete(rw.getName(), rt, acquireCount, args);
            Throwable ex = context.getCurEntry().getError();
            if (ex == null) continue;
            m.onError(rw.getName(), acquireCount, ex, args);
        }
    }
}

