/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.metric.log.block;

import com.alibaba.csp.sentinel.metric.ResourceLevelMetric;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BlockRuleTriggerMetricItem
implements ResourceLevelMetric {
    private String resource;
    private Long ruleId = 0L;
    private String exceptionType;
    private String origin;
    private String ruleLimitApp;
    private long timestamp;
    private Integer blockCount = 0;

    @Override
    public String getResource() {
        return this.resource;
    }

    public BlockRuleTriggerMetricItem setResource(String resource) {
        this.resource = resource;
        return this;
    }

    public Long getRuleId() {
        return this.ruleId;
    }

    public BlockRuleTriggerMetricItem setRuleId(Long ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    public String getExceptionType() {
        return this.exceptionType;
    }

    public BlockRuleTriggerMetricItem setExceptionType(String exceptionType) {
        this.exceptionType = exceptionType;
        return this;
    }

    public String getOrigin() {
        return this.origin;
    }

    public BlockRuleTriggerMetricItem setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public String getRuleLimitApp() {
        return this.ruleLimitApp;
    }

    public BlockRuleTriggerMetricItem setRuleLimitApp(String ruleLimitApp) {
        this.ruleLimitApp = ruleLimitApp;
        return this;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public BlockRuleTriggerMetricItem setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Integer getBlockCount() {
        return this.blockCount;
    }

    public BlockRuleTriggerMetricItem setBlockCount(Integer blockCount) {
        this.blockCount = blockCount;
        return this;
    }

    public String toFatString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder(32);
        int n = 0;
        sb.delete(0, sb.length());
        sb.append(df.format(new Date(this.getTimestamp()))).append("|");
        String[] legalName = this.getResource().split(",");
        if (legalName != null) {
            n = legalName.length - 1;
        }
        sb.append("1").append("|");
        sb.append(this.getResource()).append(",").append(this.getExceptionType()).append(",").append(this.getRuleLimitApp()).append(",").append(this.getOrigin()).append(",");
        if (this.ruleId != null) {
            sb.append(this.ruleId);
        }
        sb.append(",").append(this.getTimestamp()).append("|");
        sb.append(this.getBlockCount()).append(",").append(0).append(",").append(n);
        sb.append('\n');
        return sb.toString();
    }

    public static BlockRuleTriggerMetricItem fromFatString(String line) {
        String[] strs = line.split("\\|");
        BlockRuleTriggerMetricItem item = new BlockRuleTriggerMetricItem();
        String[] dataString = strs[2].split(",");
        String[] countString = strs[3].split(",");
        int index = Integer.parseInt(countString[2]);
        StringBuilder legalName = new StringBuilder(32);
        for (int i = 0; i <= index; ++i) {
            if (i > 0) {
                legalName.append(",");
            }
            legalName.append(dataString[i]);
        }
        item.setResource(legalName.toString());
        item.setExceptionType(dataString[1 + index]);
        item.setRuleLimitApp(dataString[2 + index]);
        item.setOrigin(dataString[3 + index]);
        String ruleIdStr = dataString[4 + index];
        if (!StringUtil.isBlank(ruleIdStr)) {
            item.setRuleId(Long.parseLong(ruleIdStr));
        }
        item.setTimestamp(Long.parseLong(dataString[5 + index]));
        item.setBlockCount(Integer.parseInt(countString[0]));
        return item;
    }

    public String toThinString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timestamp).append("|");
        String legalName = this.resource.replaceAll("\\|", "_");
        sb.append(legalName).append("|");
        sb.append(this.exceptionType).append("|");
        sb.append(this.ruleLimitApp).append("|");
        sb.append(this.origin).append("|");
        if (this.ruleId != null) {
            sb.append(this.ruleId);
        }
        sb.append("|");
        sb.append(this.blockCount).append("|");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockRuleTriggerMetricItem that = (BlockRuleTriggerMetricItem)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        if (this.ruleId != null ? !this.ruleId.equals(that.ruleId) : that.ruleId != null) {
            return false;
        }
        if (this.exceptionType != null ? !this.exceptionType.equals(that.exceptionType) : that.exceptionType != null) {
            return false;
        }
        if (this.origin != null ? !this.origin.equals(that.origin) : that.origin != null) {
            return false;
        }
        return this.ruleLimitApp != null ? this.ruleLimitApp.equals(that.ruleLimitApp) : that.ruleLimitApp == null;
    }

    public int hashCode() {
        int result = this.resource != null ? this.resource.hashCode() : 0;
        result = 31 * result + (this.ruleId != null ? this.ruleId.hashCode() : 0);
        result = 31 * result + (this.exceptionType != null ? this.exceptionType.hashCode() : 0);
        result = 31 * result + (this.origin != null ? this.origin.hashCode() : 0);
        result = 31 * result + (this.ruleLimitApp != null ? this.ruleLimitApp.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "BlockRuleTriggerMetricItem{resource='" + this.resource + '\'' + ", ruleId=" + this.ruleId + ", exceptionType='" + this.exceptionType + '\'' + ", origin='" + this.origin + '\'' + ", ruleLimitApp='" + this.ruleLimitApp + '\'' + ", timestamp=" + this.timestamp + ", blockCount=" + this.blockCount + '}';
    }
}

