/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.metric.log.block;

import com.alibaba.csp.sentinel.metric.log.block.BlockRuleTriggerMetricItem;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.degrade.ServiceDegradedException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.alibaba.csp.sentinel.spi.ServiceLoaderUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SentinelBlockLogUtil {
    private static final ServiceLoader<BlockException> serviceLoader = ServiceLoaderUtil.getServiceLoader(BlockException.class);
    private static final Map<String, String> BLOCK_EXCEPTION_SIMPLE_NAME_CACHE = new HashMap<String, String>(){
        {
            this.put(FlowException.class.getName(), FlowException.class.getSimpleName());
            this.put(DegradeException.class.getName(), DegradeException.class.getSimpleName());
            this.put(SystemBlockException.class.getName(), SystemBlockException.class.getSimpleName());
            this.put(AuthorityException.class.getName(), AuthorityException.class.getSimpleName());
            this.put(ServiceDegradedException.class.getName(), ServiceDegradedException.class.getSimpleName());
            for (BlockException blockException : serviceLoader) {
                this.put(blockException.getClass().getName(), blockException.getClass().getSimpleName());
            }
        }
    };
    private static final ConcurrentMap<BlockRuleTriggerMetricItem, AtomicInteger> BLOCK_METRIC_MAP = new ConcurrentHashMap<BlockRuleTriggerMetricItem, AtomicInteger>();

    public static ConcurrentMap<BlockRuleTriggerMetricItem, AtomicInteger> getBlockMetricMap() {
        return BLOCK_METRIC_MAP;
    }

    public static void log(String resource, Class<? extends BlockException> exceptionType, String ruleLimitApp, String origin, Long ruleId, Integer batchCount) {
        long currentTime = TimeUtil.currentTimeMillis();
        currentTime -= currentTime % 1000L;
        String exceptionTypeName = BLOCK_EXCEPTION_SIMPLE_NAME_CACHE.get(exceptionType.getName());
        if (exceptionTypeName == null) {
            exceptionTypeName = exceptionType.getSimpleName();
        }
        BlockRuleTriggerMetricItem ruleTriggerMetric = new BlockRuleTriggerMetricItem();
        ruleTriggerMetric.setRuleId(ruleId);
        ruleTriggerMetric.setExceptionType(exceptionTypeName);
        ruleTriggerMetric.setResource(resource);
        ruleTriggerMetric.setRuleLimitApp(ruleLimitApp);
        ruleTriggerMetric.setOrigin(origin);
        ruleTriggerMetric.setTimestamp(currentTime);
        AtomicInteger value = (AtomicInteger)BLOCK_METRIC_MAP.get(ruleTriggerMetric);
        if (value != null) {
            value.addAndGet(batchCount);
        } else {
            BLOCK_METRIC_MAP.putIfAbsent(ruleTriggerMetric, new AtomicInteger(batchCount));
        }
    }

    private SentinelBlockLogUtil() {
    }
}

