/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.node.StatisticNode;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ClusterNode
extends StatisticNode {
    private final String name;
    private final int resourceType;
    private final EntryType trafficType;
    private Map<String, StatisticNode> originCountMap = new HashMap<String, StatisticNode>();
    private final ReentrantLock lock = new ReentrantLock();

    public ClusterNode(String name, int resourceType, EntryType trafficType) {
        AssertUtil.notEmpty(name, "name cannot be empty");
        this.name = name;
        this.resourceType = resourceType;
        this.trafficType = trafficType;
    }

    public String getName() {
        return this.name;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node getOrCreateOriginNode(String origin) {
        StatisticNode statisticNode = this.originCountMap.get(origin);
        if (statisticNode == null) {
            int maxOriginLimit = SentinelConfig.maxOriginAmount();
            if (this.originCountMap.size() >= maxOriginLimit) {
                return null;
            }
            this.lock.lock();
            try {
                statisticNode = this.originCountMap.get(origin);
                if (statisticNode == null) {
                    if (this.originCountMap.size() >= maxOriginLimit) {
                        Node node = null;
                        return node;
                    }
                    statisticNode = new StatisticNode();
                    HashMap<String, StatisticNode> newMap = new HashMap<String, StatisticNode>(this.originCountMap.size() + 1);
                    newMap.putAll(this.originCountMap);
                    newMap.put(origin, statisticNode);
                    this.originCountMap = newMap;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return statisticNode;
    }

    public void clearOriginMap() {
        this.lock.lock();
        try {
            this.originCountMap = new HashMap<String, StatisticNode>(16);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, StatisticNode> getOriginCountMap() {
        return this.originCountMap;
    }

    public void trace(Throwable throwable, int count) {
        if (count <= 0) {
            return;
        }
        if (!BlockException.isBlockException(throwable)) {
            this.increaseExceptionQps(count);
        }
    }

    public EntryType getTrafficType() {
        return this.trafficType;
    }
}

