/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.property.SimplePropertyListener;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;

public class SampleCountProperty {
    private static volatile int slidingWindowSampleCount = SentinelConfig.slidingWindowSampleCount();

    public static int getSampleCount() {
        return slidingWindowSampleCount;
    }

    public static void register2Property(SentinelProperty<Integer> property) {
        property.addListener((PropertyListener<Integer>)new SimplePropertyListener<Integer>(){

            @Override
            public void configUpdate(Integer value) {
                if (value != null) {
                    SampleCountProperty.updateSampleCount(value);
                }
            }
        });
    }

    public static void updateSampleCount(int newSampleCount) {
        if (newSampleCount != slidingWindowSampleCount) {
            slidingWindowSampleCount = newSampleCount;
            ClusterBuilderSlot.resetClusterNodes();
        }
        RecordLog.info("[SampleCountProperty] SlidingWindowSampleCount has been updated to " + slidingWindowSampleCount, new Object[0]);
    }
}

