/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.retry;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.property.SimplePropertyListener;
import com.alibaba.csp.sentinel.retry.RetryRule;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.CollectionUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RetryRuleManager {
    private volatile Map<String, RetryRule> ruleMap = new HashMap<String, RetryRule>();
    private SentinelProperty<List<RetryRule>> currentProperty = new DynamicSentinelProperty<List<RetryRule>>();
    private final RetryRulePropertyListener propertyListener = new RetryRulePropertyListener();

    protected RetryRuleManager() {
        this.currentProperty.addListener(this.propertyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register2Property(SentinelProperty<List<RetryRule>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        RetryRulePropertyListener retryRulePropertyListener = this.propertyListener;
        synchronized (retryRulePropertyListener) {
            RecordLog.info("[RetryRuleManager] Registering new property to retry rule manager", new Object[0]);
            this.currentProperty.removeListener(this.propertyListener);
            property.addListener(this.propertyListener);
            this.currentProperty = property;
        }
    }

    public boolean loadRules(List<RetryRule> rules) {
        return this.currentProperty.updateValue(rules);
    }

    public List<RetryRule> getRules() {
        ArrayList<RetryRule> list = new ArrayList<RetryRule>();
        for (Map.Entry<String, RetryRule> e : this.ruleMap.entrySet()) {
            if (e.getValue() == null) continue;
            list.add(e.getValue());
        }
        return list;
    }

    public RetryRule getRuleOfResource(String resource) {
        if (resource == null) {
            return null;
        }
        return this.ruleMap.get(resource);
    }

    public static boolean isValidRule(RetryRule rule) {
        if (rule == null || rule.getRetryIntervalStrategy() == null) {
            return false;
        }
        if (StringUtil.isBlank(rule.getResource())) {
            return false;
        }
        if (rule.getMaxRetryTimes() <= 0 || rule.getRetryBaseIntervalMs() <= 0) {
            return false;
        }
        if (rule.getErrorRatioUpperBound() <= 0.0 || rule.getErrorRatioUpperBound() > 1.0) {
            return false;
        }
        RetryRule.RetryPredicateStrategy predicateStrategy = rule.getRetryPredicateStrategy();
        if (predicateStrategy == null) {
            return false;
        }
        return predicateStrategy != RetryRule.RetryPredicateStrategy.WHITELIST_EXCEPTIONS || !CollectionUtil.isEmpty(rule.getExceptionPredicates());
    }

    public static RetryRuleManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final RetryRuleManager INSTANCE = new RetryRuleManager();

        private InstanceHolder() {
        }
    }

    private class RetryRulePropertyListener
    extends SimplePropertyListener<List<RetryRule>> {
        private RetryRulePropertyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configUpdate(List<RetryRule> list) {
            Map<String, RetryRule> newMap = this.buildNewMap(list);
            RetryRulePropertyListener retryRulePropertyListener = this;
            synchronized (retryRulePropertyListener) {
                RetryRuleManager.this.ruleMap = newMap;
                RecordLog.info("[RetryRuleManager] Retry rules has been updated to: " + newMap, new Object[0]);
            }
        }

        private Map<String, RetryRule> buildNewMap(List<RetryRule> list) {
            HashMap<String, RetryRule> map = new HashMap<String, RetryRule>(8);
            if (list == null || list.isEmpty()) {
                return map;
            }
            for (RetryRule rule : list) {
                if (!RetryRuleManager.isValidRule(rule)) {
                    RecordLog.warn("[RetryRuleManager] Ignoring invalid rule when loading new rules: " + rule, new Object[0]);
                    continue;
                }
                RetryRule prevRule = (RetryRule)map.get(rule.getResource());
                if (prevRule != null) {
                    RecordLog.info("[RetryRuleManager] Only one rule is needed for a single resource, so ignoring previous rule: " + prevRule, new Object[0]);
                }
                map.put(rule.getResource(), rule);
            }
            return map;
        }
    }
}

