/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.setting.fallback;

import com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.degrade.ServiceDegradedException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.alibaba.csp.sentinel.web.adapter.common.rule.WebFlowException;
import java.util.HashMap;
import java.util.Map;

public final class BlockFallbackConstants {
    public static final int TARGET_RES_TYPE_WEB = 1;
    public static final int TARGET_RES_TYPE_RPC = 2;
    public static final int RPC_BLOCK_CUSTOM_RETURN_OBJ = 0;
    public static final int RPC_BLOCK_CUSTOM_EXCEPTION = 1;
    public static final int CACHE_RPC_FALLBACK_CONFIG = 1;
    public static final int RPC_FALLBACK_MANUAL_OPERATE_MODE = 0;
    public static final int RPC_FALLBACK_AUTO_OPERATE_MODE = 1;
    public static final int BLOCK_TYPE_ALL = 0;
    public static final int BLOCK_TYPE_FLOW = 1;
    public static final int BLOCK_TYPE_CIRCUIT_BREAKING = 2;
    public static final int BLOCK_TYPE_SYSTEM = 3;
    public static final int BLOCK_TYPE_PARAM_FLOW = 4;
    public static final int BLOCK_TYPE_MANUAL_DEGRADE = 5;
    public static final int BLOCK_TYPE_WEB_FLOW = 11;
    public static final String SYSTEM_RESOURCE = "__system_block_exception_resource__";
    private static final Map<Integer, Class<?>> TARGET_RES_TYPE_MAP = new HashMap<Integer, Class<?>>(){
        {
            this.put(1, BlockFallbackConfig.WebBlockFallbackBehavior.class);
            this.put(2, BlockFallbackConfig.RpcBlockFallbackBehavior.class);
        }
    };
    private static final Map<Class<?>, Integer> BLOCK_TYPE_MAP = new HashMap<Class<?>, Integer>(){
        {
            this.put(FlowException.class, 1);
            this.put(DegradeException.class, 2);
            this.put(SystemBlockException.class, 3);
            this.put(ServiceDegradedException.class, 5);
            this.put(ParamFlowException.class, 4);
            this.put(WebFlowException.class, 11);
        }
    };

    public static Integer parseBlockType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return BLOCK_TYPE_MAP.get(clazz);
    }

    public static boolean isResourceTypeSupported(int t) {
        return TARGET_RES_TYPE_MAP.containsKey(t);
    }

    public static boolean isResourceTypeSupportedAndMatch(int t, Object behavior) {
        Class<?> clazz = TARGET_RES_TYPE_MAP.get(t);
        if (clazz == null) {
            return false;
        }
        return clazz.isAssignableFrom(behavior.getClass());
    }

    private BlockFallbackConstants() {
    }
}

