/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker;

import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.AbstractRatioBasedCircuitBreaker;
import com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.LongAdder;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.List;

public class ResponseTimeCircuitBreaker
extends AbstractRatioBasedCircuitBreaker {
    private final long maxAllowedRt;
    private final int minRequestAmount;
    private final LeapArray<SlowRequestCounter> slidingCounter;

    public ResponseTimeCircuitBreaker(DegradeRule rule) {
        this(rule, new SlowRequestLeapArray(1, rule.getStatIntervalMs()));
    }

    ResponseTimeCircuitBreaker(DegradeRule rule, LeapArray<SlowRequestCounter> stat) {
        super(rule, rule.getSlowRatioThreshold());
        AssertUtil.isTrue(rule.getGrade() == 0, "rule metric type should be RT");
        AssertUtil.notNull(stat, "stat cannot be null");
        this.maxAllowedRt = Math.round(rule.getCount());
        this.minRequestAmount = rule.getMinRequestAmount();
        this.slidingCounter = stat;
    }

    @Override
    public void resetStat() {
        this.slidingCounter.currentWindow().value().reset();
        this.curCompleteAmountDuringRecovery.set(0);
        this.curPassAmountDuringRecovery.set(1);
    }

    @Override
    public void onRequestComplete(long rt, Throwable error) {
        SlowRequestCounter counter = this.slidingCounter.currentWindow().value();
        if (rt > this.maxAllowedRt) {
            counter.slowCount.add(1L);
        }
        counter.totalCount.add(1L);
        this.handleStateChangeWhenThresholdExceeded(rt);
    }

    private void handleStateChangeWhenThresholdExceeded(long rt) {
        if (this.currentState.get() == CircuitBreaker.State.OPEN) {
            return;
        }
        List<SlowRequestCounter> counters = this.slidingCounter.values();
        long slowCount = 0L;
        long totalCount = 0L;
        for (SlowRequestCounter counter : counters) {
            slowCount += counter.slowCount.sum();
            totalCount += counter.totalCount.sum();
        }
        if (this.currentState.get() == CircuitBreaker.State.HALF_OPEN) {
            this.handleStateChangeToHalfOpenWhenThresholdExceeded(slowCount, totalCount);
            return;
        }
        if (totalCount < (long)this.minRequestAmount) {
            return;
        }
        double currentRatio = (double)slowCount * 1.0 / (double)totalCount;
        if (currentRatio >= this.ratioThreshold) {
            this.transformToOpen(currentRatio);
        }
    }

    static class SlowRequestLeapArray
    extends LeapArray<SlowRequestCounter> {
        public SlowRequestLeapArray(int sampleCount, int intervalInMs) {
            super(sampleCount, intervalInMs);
        }

        @Override
        public SlowRequestCounter newEmptyBucket(long timeMillis) {
            return new SlowRequestCounter();
        }

        @Override
        protected WindowWrap<SlowRequestCounter> resetWindowTo(WindowWrap<SlowRequestCounter> w, long startTime) {
            w.resetTo(startTime);
            w.value().reset();
            return w;
        }
    }

    static class SlowRequestCounter {
        private LongAdder slowCount = new LongAdder();
        private LongAdder totalCount = new LongAdder();

        public LongAdder getSlowCount() {
            return this.slowCount;
        }

        public LongAdder getTotalCount() {
            return this.totalCount;
        }

        public SlowRequestCounter reset() {
            this.slowCount.reset();
            this.totalCount.reset();
            return this;
        }

        public String toString() {
            return "SlowRequestCounter{slowCount=" + this.slowCount + ", totalCount=" + this.totalCount + '}';
        }
    }
}

