/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.controller;

import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;
import com.alibaba.csp.sentinel.util.AssertUtil;

public class DefaultConcurrencyController
implements TrafficShapingController {
    private final long maxConcurrency;

    public DefaultConcurrencyController(long maxConcurrency) {
        AssertUtil.assertTrue(maxConcurrency >= 0L, "maxConcurrency requires >= 0");
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public boolean canPass(Node node, int acquireCount, boolean prioritized) {
        return this.canPass(node, acquireCount);
    }

    @Override
    public boolean canPass(Node node, int acquireCount) {
        if (acquireCount <= 0) {
            return true;
        }
        int cur = this.currentConcurrency(node);
        return (long)(cur + acquireCount) <= this.maxConcurrency;
    }

    private int currentConcurrency(Node node) {
        return node == null ? 0 : node.curThreadNum();
    }
}

