/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.controller;

import com.alibaba.csp.sentinel.node.Node;
import com.alibaba.csp.sentinel.node.OccupyTimeoutProperty;
import com.alibaba.csp.sentinel.slots.block.flow.PriorityWaitException;
import com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;
import com.alibaba.csp.sentinel.slots.block.flow.tokenbucket.DefaultTokenBucket;
import com.alibaba.csp.sentinel.slots.block.flow.tokenbucket.StrictTokenBucket;
import com.alibaba.csp.sentinel.slots.block.flow.tokenbucket.TokenBucket;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;

public class DefaultRequestCountController
implements TrafficShapingController {
    private final double threshold;
    private final long statDurationMs;
    private final boolean strictModeEnabled;
    private final boolean individualStatRequired;
    private TokenBucket tokenBucket;

    public DefaultRequestCountController(double threshold, long statDurationMs, boolean strictModeEnabled) {
        AssertUtil.assertTrue(threshold >= 0.0, "threshold requires >= 0");
        AssertUtil.assertTrue(statDurationMs >= 0L, "statDurationMs requires >= 0");
        this.threshold = threshold;
        this.statDurationMs = statDurationMs;
        this.strictModeEnabled = strictModeEnabled;
        boolean bl = this.individualStatRequired = statDurationMs != 1000L;
        if (this.individualStatRequired) {
            this.tokenBucket = this.createTokenBucket(threshold, statDurationMs, strictModeEnabled);
        }
    }

    private TokenBucket createTokenBucket(double threshold, long statDurationMs, boolean strictModeEnabled) {
        long maxQuota = (long)Math.floor(threshold);
        if (strictModeEnabled) {
            return new StrictTokenBucket(maxQuota, maxQuota, true, statDurationMs);
        }
        return new DefaultTokenBucket(maxQuota, maxQuota, true, statDurationMs);
    }

    @Override
    public boolean canPass(Node node, int acquireCount) {
        return this.canPass(node, acquireCount, false);
    }

    @Override
    public boolean canPass(Node node, int acquireCount, boolean prioritized) {
        if (acquireCount <= 0) {
            return true;
        }
        if (!this.individualStatRequired) {
            return this.checkDefaultStatQpsPass(node, acquireCount, prioritized);
        }
        return this.tokenBucket.tryConsume(acquireCount);
    }

    private double curUsedQuotaOfStatNode(Node node) {
        return node == null ? 0.0 : node.passQps();
    }

    private boolean checkDefaultStatQpsPass(Node node, int acquireCount, boolean prioritized) {
        long currentTime;
        long waitInMs;
        double curUsed = this.curUsedQuotaOfStatNode(node);
        if (curUsed + (double)acquireCount <= this.threshold) {
            return true;
        }
        if (prioritized && (waitInMs = node.tryOccupyNext(currentTime = TimeUtil.currentTimeMillis(), acquireCount, this.threshold)) < (long)OccupyTimeoutProperty.getOccupyTimeout()) {
            node.addWaitingRequest(currentTime + waitInMs, acquireCount);
            node.addOccupiedPass(acquireCount);
            this.sleep(waitInMs);
            throw new PriorityWaitException(waitInMs);
        }
        return false;
    }

    private void sleep(long timeMillis) {
        try {
            Thread.sleep(timeMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

