/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.exception;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import com.alibaba.csp.sentinel.slots.block.flow.exception.ExceptionStatistics;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExceptionMetricsManager {
    public static final String EXCEPTION_METRICS_LOG_FILE_SUFFIX = "exception_metrics.log";
    private static volatile ExceptionMetricsManager exceptionMetricsManager;
    private static final int KEEP_ALIVE_TIME = 120000;
    private static final int QUEUE_SIZE = 10000;
    private static final long TEN_SECONDS = 10000L;
    private static final int MAX_CONTAINER_SIZE = 200;
    public static final int EXP_MESSAGE_MAX_LENGTH = 200;
    public static final String EMPTY_STR = "";
    private final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());
    private final ExecutorService recordTaskPool;
    private final ScheduledExecutorService aggregatorTaskScheduler;
    private final ScheduledExecutorService writeTaskScheduler;
    private volatile List<String> exceptions = new ArrayList<String>(0);
    private final List<String> exceptionContainer = new CopyOnWriteArrayList<String>();
    private final ThreadLocal<SimpleDateFormat> commonDateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExceptionMetricsManager getInstance() {
        if (exceptionMetricsManager != null) return exceptionMetricsManager;
        Class<ExceptionMetricsManager> clazz = ExceptionMetricsManager.class;
        synchronized (ExceptionMetricsManager.class) {
            if (exceptionMetricsManager != null) return exceptionMetricsManager;
            exceptionMetricsManager = new ExceptionMetricsManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return exceptionMetricsManager;
        }
    }

    private ExceptionMetricsManager() {
        int coreNum = Runtime.getRuntime().availableProcessors();
        int poolSize = Math.min(coreNum, 4);
        this.recordTaskPool = new ThreadPoolExecutor(poolSize, poolSize, 120000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10000), new NamedThreadFactory("sentinel-metrics-exception-record-backend-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.aggregatorTaskScheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("sentinel-exception-metrics-aggregator-scheduler", true));
        this.aggregatorTaskScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ExceptionMetricsManager.this.exceptions = ExceptionStatistics.getInstance().getExceptions();
                }
                catch (Exception e) {
                    RecordLog.warn("[ExceptionManager] Failed to statistic exceptions ", e);
                }
            }
        }, 5000L, 10000L, TimeUnit.MILLISECONDS);
        this.writeTaskScheduler = Executors.newScheduledThreadPool(1, new NamedThreadFactory("sentinel-exception-metrics-writer-scheduler", true));
        this.writeTaskScheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<String> exps = new ArrayList<String>(ExceptionMetricsManager.this.exceptionContainer);
                    ExceptionMetricsManager.this.metricWriter.commonWrite(TimeUtil.currentTimeMillis() / 1000L * 1000L, exps, ExceptionMetricsManager.EXCEPTION_METRICS_LOG_FILE_SUFFIX);
                    ExceptionMetricsManager.this.exceptionContainer.clear();
                }
                catch (Exception e) {
                    RecordLog.warn("[ExceptionManager] Failed to write exceptions ", e);
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void recordException(final String resource, final Throwable throwable) {
        if (resource == null || throwable == null) {
            return;
        }
        this.recordTaskPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ExceptionStatistics.getInstance().recordException(resource, throwable);
                }
                catch (Throwable e) {
                    RecordLog.warn("[EXCEPTION-MANGER] set exception failed {} ", resource, e);
                }
                try {
                    Throwable cause;
                    Throwable exception;
                    String expInfo;
                    if (ExceptionMetricsManager.this.exceptionContainer.size() > 200) {
                        ExceptionMetricsManager.this.exceptionContainer.clear();
                    }
                    if (StringUtil.isBlank(expInfo = (exception = (cause = throwable.getCause()) == null ? throwable : cause).getMessage())) {
                        expInfo = ExceptionMetricsManager.EMPTY_STR;
                    } else if (expInfo.length() > 200) {
                        expInfo = expInfo.substring(0, 200);
                    }
                    if (expInfo.indexOf(10) >= 0) {
                        expInfo = StringUtil.replace(expInfo, "\n", " ");
                    }
                    String dateStr = ((SimpleDateFormat)ExceptionMetricsManager.this.commonDateFormatThreadLocal.get()).format(new Date());
                    ExceptionMetricsManager.this.exceptionContainer.add(dateStr + "|" + resource + "|" + expInfo);
                }
                catch (Throwable e) {
                    RecordLog.warn("[EXCEPTION-MANGER] save exception info failed {} ", resource, e);
                }
            }
        });
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }
}

