/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.exception;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.exception.domain.AbnormalInfo;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ExceptionStatistics {
    private static final String EMPTY_STR = "";
    private static volatile ExceptionStatistics exceptionStatistics;
    private final Map<AbnormalInfo, String> exceptions = new ConcurrentHashMap<AbnormalInfo, String>();
    private final Map<AbnormalInfo, Map<Long, Integer>> exceptionNums = new ConcurrentHashMap<AbnormalInfo, Map<Long, Integer>>();

    private ExceptionStatistics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExceptionStatistics getInstance() {
        if (exceptionStatistics != null) return exceptionStatistics;
        Class<ExceptionStatistics> clazz = ExceptionStatistics.class;
        synchronized (ExceptionStatistics.class) {
            if (exceptionStatistics != null) return exceptionStatistics;
            exceptionStatistics = new ExceptionStatistics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return exceptionStatistics;
        }
    }

    public void recordException(String resource, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        try {
            Integer num;
            Map<Long, Integer> nums;
            Throwable cause = throwable.getCause();
            Throwable exp = cause == null ? throwable : cause;
            String exception = exp.getClass().getName();
            AbnormalInfo basicException = new AbnormalInfo(resource, exception);
            String detail = this.exceptions.get(basicException);
            if (detail == null) {
                String expInfo = exp.getMessage();
                if (StringUtil.isEmpty(expInfo)) {
                    expInfo = EMPTY_STR;
                } else {
                    if (expInfo.length() > 200) {
                        expInfo = expInfo.substring(0, 200);
                    }
                    if (expInfo.indexOf(10) >= 0) {
                        expInfo = StringUtil.replace(expInfo, "\n", " ");
                    }
                    if (expInfo.indexOf(124) >= 0) {
                        expInfo = expInfo.replace("|", "-");
                    }
                }
                this.exceptions.put(basicException, expInfo);
            }
            if ((nums = this.exceptionNums.get(basicException)) == null) {
                nums = new ConcurrentHashMap<Long, Integer>();
            }
            long time = TimeUtil.currentTimeMillis();
            if ((num = nums.get(time -= time % 1000L)) == null) {
                num = 0;
            }
            nums.put(time, num + 1);
            this.exceptionNums.put(basicException, nums);
        }
        catch (Throwable e) {
            RecordLog.warn("[EXCEPTION-STATISTICS] write exception with resource: {} failed ", resource, e);
        }
    }

    public List<String> getExceptions() {
        boolean storeOK = true;
        ArrayList<String> res = new ArrayList<String>();
        try {
            Set<AbnormalInfo> resources = this.exceptions.keySet();
            if (resources.isEmpty()) {
                return Collections.emptyList();
            }
            for (AbnormalInfo resource : resources) {
                String detail = this.exceptions.get(resource);
                if (detail == null) continue;
                String exception = resource.toString() + "," + detail + "," + this.geneTimestampStatistics(resource);
                res.add(exception);
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[EXCEPTION-STATISTICS] get exceptions failed ", e);
            storeOK = false;
        }
        if (storeOK) {
            this.exceptions.clear();
            this.exceptionNums.clear();
        }
        return res;
    }

    private String geneTimestampStatistics(AbnormalInfo resource) {
        Map<Long, Integer> nums = this.exceptionNums.get(resource);
        StringBuilder builder = new StringBuilder();
        Set<Long> keys = nums.keySet();
        for (Long key : keys) {
            builder.append(key).append("|").append(nums.get(key));
            builder.append("#");
        }
        return builder.substring(0, builder.lastIndexOf("#"));
    }
}

