/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.param;

import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenService;
import com.alibaba.csp.sentinel.cluster.client.TokenClientProvider;
import com.alibaba.csp.sentinel.cluster.server.EmbeddedClusterTokenServerProvider;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetricStorage;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ParamFlowChecker {
    public static boolean passCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object ... args) {
        if (args == null) {
            return true;
        }
        int paramIdx = rule.getParamIdx();
        if (args.length <= paramIdx) {
            return true;
        }
        Object value = args[paramIdx];
        if (value == null) {
            return true;
        }
        if (rule.isClusterMode() && rule.getGrade() == 1) {
            return ParamFlowChecker.passClusterCheck(resourceWrapper, rule, count, value);
        }
        return ParamFlowChecker.passLocalCheck(resourceWrapper, rule, count, value);
    }

    public static boolean passCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Map<String, Object> argMap) {
        if (argMap == null) {
            return true;
        }
        String param = rule.getParamKey();
        if (param == null) {
            return true;
        }
        Object value = argMap.get(param);
        if (value == null) {
            return true;
        }
        if (rule.isClusterMode() && rule.getGrade() == 1) {
            return ParamFlowChecker.passClusterCheck(resourceWrapper, rule, count, value);
        }
        return ParamFlowChecker.passLocalCheck(resourceWrapper, rule, count, value);
    }

    private static boolean passLocalCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object value) {
        block6: {
            try {
                if (Collection.class.isAssignableFrom(value.getClass())) {
                    for (Object param : (Collection)value) {
                        if (ParamFlowChecker.passSingleValueCheck(resourceWrapper, rule, count, param)) continue;
                        return false;
                    }
                    break block6;
                }
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Object param = Array.get(value, i);
                        if (ParamFlowChecker.passSingleValueCheck(resourceWrapper, rule, count, param)) continue;
                        return false;
                    }
                    break block6;
                }
                return ParamFlowChecker.passSingleValueCheck(resourceWrapper, rule, count, value);
            }
            catch (Throwable e) {
                RecordLog.warn("[ParamFlowChecker] Unexpected error", e);
            }
        }
        return true;
    }

    static boolean passSingleValueCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int acquireCount, Object value) {
        return ParamFlowChecker.passSingleValueCheck(resourceWrapper, rule, acquireCount, value, false);
    }

    static boolean passSingleValueCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int acquireCount, Object value, boolean clusterFallback) {
        if (rule.getGrade() == 1) {
            if (rule.getControlBehavior() == 2) {
                return ParamFlowChecker.passThrottleLocalCheck(resourceWrapper, rule, acquireCount, value, clusterFallback);
            }
            return ParamFlowChecker.passDefaultLocalCheck(resourceWrapper, rule, acquireCount, value, clusterFallback);
        }
        if (rule.getGrade() == 0) {
            long threadCount = ParamFlowChecker.getParameterMetric(resourceWrapper).getThreadCount(rule.getParamIdx(), value);
            Double itemThreshold = rule.retrieveThresholdOfItem(value, clusterFallback);
            if (itemThreshold != null) {
                return ++threadCount <= itemThreshold.longValue();
            }
            long threshold = (long)rule.getCount();
            return ++threadCount <= threshold;
        }
        return true;
    }

    static boolean passDefaultLocalCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int acquireCount, Object value, boolean clusterFallback) {
        CacheMap<Object, AtomicLong> timeCounters;
        ParameterMetric metric = ParamFlowChecker.getParameterMetric(resourceWrapper);
        CacheMap<Object, AtomicLong> tokenCounters = metric == null ? null : metric.getRuleTokenCounter(rule);
        CacheMap<Object, AtomicLong> cacheMap = timeCounters = metric == null ? null : metric.getRuleTimeCounter(rule);
        if (tokenCounters == null || timeCounters == null) {
            return true;
        }
        long tokenCount = (long)rule.getCount();
        Double itemThreshold = rule.retrieveThresholdOfItem(value, clusterFallback);
        if (itemThreshold != null) {
            tokenCount = itemThreshold.longValue();
        }
        if (tokenCount == 0L) {
            return false;
        }
        long maxCount = tokenCount + (long)rule.getBurstCount();
        if ((long)acquireCount > maxCount) {
            return false;
        }
        while (true) {
            AtomicLong oldQps;
            long currentTime;
            AtomicLong lastAddTokenTime;
            if ((lastAddTokenTime = timeCounters.putIfAbsent(value, new AtomicLong(currentTime = TimeUtil.currentTimeMillis()))) == null) {
                tokenCounters.putIfAbsent(value, new AtomicLong(maxCount - (long)acquireCount));
                return true;
            }
            long passTime = currentTime - lastAddTokenTime.get();
            if (passTime > rule.getDurationInSec() * 1000L) {
                long newQps;
                oldQps = tokenCounters.putIfAbsent(value, new AtomicLong(maxCount - (long)acquireCount));
                if (oldQps == null) {
                    lastAddTokenTime.set(currentTime);
                    return true;
                }
                long restQps = oldQps.get();
                long toAddCount = passTime * tokenCount / (rule.getDurationInSec() * 1000L);
                long l = newQps = toAddCount + restQps > maxCount ? maxCount - (long)acquireCount : restQps + toAddCount - (long)acquireCount;
                if (newQps < 0L) {
                    return false;
                }
                if (oldQps.compareAndSet(restQps, newQps)) {
                    lastAddTokenTime.set(currentTime);
                    return true;
                }
                Thread.yield();
                continue;
            }
            oldQps = tokenCounters.get(value);
            if (oldQps != null) {
                long oldQpsValue = oldQps.get();
                if (oldQpsValue - (long)acquireCount >= 0L) {
                    if (oldQps.compareAndSet(oldQpsValue, oldQpsValue - (long)acquireCount)) {
                        return true;
                    }
                } else {
                    return false;
                }
            }
            Thread.yield();
        }
    }

    static boolean passThrottleLocalCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int acquireCount, Object value, boolean clusterFallback) {
        CacheMap<Object, AtomicLong> timeRecorderMap;
        ParameterMetric metric = ParamFlowChecker.getParameterMetric(resourceWrapper);
        CacheMap<Object, AtomicLong> cacheMap = timeRecorderMap = metric == null ? null : metric.getRuleTimeCounter(rule);
        if (timeRecorderMap == null) {
            return true;
        }
        long tokenCount = (long)rule.getCount();
        Double itemThreshold = rule.retrieveThresholdOfItem(value, clusterFallback);
        if (itemThreshold != null) {
            tokenCount = itemThreshold.longValue();
        }
        if (tokenCount == 0L) {
            return false;
        }
        long costTime = Math.round(1000.0 * (double)acquireCount * (double)rule.getDurationInSec() / (double)tokenCount);
        while (true) {
            long currentTime;
            AtomicLong timeRecorder;
            if ((timeRecorder = timeRecorderMap.putIfAbsent(value, new AtomicLong(currentTime = TimeUtil.currentTimeMillis()))) == null) {
                return true;
            }
            long lastPassTime = timeRecorder.get();
            long expectedTime = lastPassTime + costTime;
            if (expectedTime > currentTime && expectedTime - currentTime >= (long)rule.getMaxQueueingTimeMs()) break;
            AtomicLong lastPastTimeRef = timeRecorderMap.get(value);
            if (lastPastTimeRef.compareAndSet(lastPassTime, currentTime)) {
                long waitTime = expectedTime - currentTime;
                if (waitTime > 0L) {
                    lastPastTimeRef.set(expectedTime);
                    try {
                        TimeUnit.MILLISECONDS.sleep(waitTime);
                    }
                    catch (InterruptedException e) {
                        RecordLog.warn("passThrottleLocalCheck: wait interrupted", e);
                    }
                }
                return true;
            }
            Thread.yield();
        }
        return false;
    }

    private static ParameterMetric getParameterMetric(ResourceWrapper resourceWrapper) {
        return ParameterMetricStorage.getParamMetric(resourceWrapper);
    }

    private static Collection<Object> toCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            ArrayList<Object> params = new ArrayList<Object>();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object param = Array.get(value, i);
                params.add(param);
            }
            return params;
        }
        return Collections.singletonList(value);
    }

    private static boolean passClusterCheck(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object value) {
        try {
            Collection<Object> params = ParamFlowChecker.toCollection(value);
            TokenService clusterService = ParamFlowChecker.pickClusterService();
            if (clusterService == null) {
                return ParamFlowChecker.fallbackToLocalOrPass(resourceWrapper, rule, count, params);
            }
            TokenResult result = clusterService.requestParamToken(rule.getClusterConfig().getFlowId(), count, params);
            switch (result.getStatus()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return ParamFlowChecker.fallbackToLocalOrPass(resourceWrapper, rule, count, params);
        }
        catch (Throwable ex) {
            RecordLog.warn("[ParamFlowChecker] Request cluster token for parameter unexpected failed", ex);
            return ParamFlowChecker.fallbackToLocalOrPass(resourceWrapper, rule, count, value);
        }
    }

    private static boolean fallbackToLocalOrPass(ResourceWrapper resourceWrapper, ParamFlowRule rule, int count, Object value) {
        if (rule.getClusterConfig().isFallbackToLocalWhenFail()) {
            return ParamFlowChecker.passLocalCheck(resourceWrapper, rule, count, value);
        }
        return true;
    }

    private static TokenService pickClusterService() {
        if (ClusterStateManager.isClient()) {
            return TokenClientProvider.getClient();
        }
        if (ClusterStateManager.isServer()) {
            return EmbeddedClusterTokenServerProvider.getServer();
        }
        return null;
    }

    private ParamFlowChecker() {
    }
}

