/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.statuscode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StatusCodeMetric {
    private static volatile StatusCodeMetric statusCodeMetric;
    private final Map<String, Map<Long, AtomicInteger[]>> statusCodeMetrics = new ConcurrentHashMap<String, Map<Long, AtomicInteger[]>>();

    private StatusCodeMetric() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatusCodeMetric getInstance() {
        if (statusCodeMetric != null) return statusCodeMetric;
        Class<StatusCodeMetric> clazz = StatusCodeMetric.class;
        synchronized (StatusCodeMetric.class) {
            if (statusCodeMetric != null) return statusCodeMetric;
            statusCodeMetric = new StatusCodeMetric();
            // ** MonitorExit[var0] (shouldn't be in output)
            return statusCodeMetric;
        }
    }

    public void statisticStatusCode(String resource, long time, int statusCode) {
        AtomicInteger[] statistics;
        Map<Long, AtomicInteger[]> timeStatistics = this.statusCodeMetrics.get(resource);
        if (timeStatistics == null) {
            timeStatistics = new ConcurrentHashMap<Long, AtomicInteger[]>();
        }
        if ((statistics = timeStatistics.get(time)) == null) {
            statistics = new AtomicInteger[5];
            for (int i = 0; i < 5; ++i) {
                statistics[i] = new AtomicInteger();
            }
        }
        this.setStatusCodeMetrics(statistics, statusCode);
        timeStatistics.put(time, statistics);
        this.statusCodeMetrics.put(resource, timeStatistics);
    }

    private void setStatusCodeMetrics(AtomicInteger[] statistics, int statusCode) {
        if (statusCode == 200) {
            statistics[0].getAndIncrement();
        } else if (statusCode > 200 && statusCode < 300) {
            statistics[1].getAndIncrement();
        } else if (statusCode >= 300 && statusCode < 400) {
            statistics[2].getAndIncrement();
        } else if (statusCode >= 400 && statusCode < 500) {
            statistics[3].getAndIncrement();
        } else {
            statistics[4].getAndIncrement();
        }
    }

    public String getStatisticStatusCode(String resource, long time) {
        if (!this.statusCodeMetrics.containsKey(resource)) {
            return "";
        }
        Map<Long, AtomicInteger[]> timeStatistics = this.statusCodeMetrics.get(resource);
        if (!timeStatistics.containsKey(time)) {
            return "";
        }
        AtomicInteger[] statistics = timeStatistics.get(time);
        return statistics[0].get() + "|" + statistics[1].get() + "|" + statistics[2].get() + "|" + statistics[3].get() + "|" + statistics[4].get();
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.statusCodeMetrics.keySet());
    }

    public Map<Long, AtomicInteger[]> getMetrics(String key) {
        return this.statusCodeMetrics.get(key);
    }

    public void setMetrics(String key, Map<Long, AtomicInteger[]> metrics) {
        this.statusCodeMetrics.put(key, metrics);
    }
}

