/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.tokenbucket;

import com.alibaba.csp.sentinel.slots.block.flow.tokenbucket.TokenBucket;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;

public abstract class AbstractTokenBucket
implements TokenBucket {
    protected final long MAX_UNIT_PRODUCE_NUM = Long.MAX_VALUE;
    protected volatile long currentTokenNum;
    protected volatile long nextProduceTime;
    protected final long unitProduceNum;
    protected final long maxTokenNum;
    protected final long intervalInMs;
    protected final long startTime;

    public AbstractTokenBucket(long unitProduceNum, long maxTokenNum, boolean fullStart, long intervalInMs) {
        AssertUtil.assertTrue(unitProduceNum > 0L && intervalInMs > 0L && unitProduceNum < Long.MAX_VALUE, "Illegal unitProduceNum or intervalInSeconds");
        AssertUtil.assertTrue(maxTokenNum > 0L, "Illegal maxTokenNum");
        this.unitProduceNum = unitProduceNum;
        this.maxTokenNum = maxTokenNum;
        this.intervalInMs = intervalInMs;
        this.nextProduceTime = this.startTime = TimeUtil.currentTimeMillis();
        this.currentTokenNum = fullStart ? maxTokenNum : 0L;
    }

    @Override
    public boolean tryConsume(long tokenNum) {
        if (tokenNum <= 0L) {
            return true;
        }
        if (tokenNum > this.maxTokenNum) {
            return false;
        }
        long currentTimestamp = TimeUtil.currentTimeMillis();
        this.refreshCurrentTokenNum(currentTimestamp);
        if (tokenNum <= this.currentTokenNum) {
            this.currentTokenNum -= tokenNum;
            return true;
        }
        return false;
    }

    @Override
    public void refreshCurrentTokenNum(long currentTimestamp) {
        if (this.nextProduceTime > currentTimestamp) {
            return;
        }
        this.currentTokenNum = Math.min(this.maxTokenNum, this.currentTokenNum + this.calProducedTokenNum(currentTimestamp));
        this.updateNextProduceTime(currentTimestamp);
    }

    protected long calProducedTokenNum(long currentTimestamp) {
        if (this.nextProduceTime > currentTimestamp) {
            return 0L;
        }
        long nextRefreshUnitCount = (this.nextProduceTime - this.startTime) / this.intervalInMs;
        long currentUnitCount = (currentTimestamp - this.startTime) / this.intervalInMs;
        long unitCount = currentUnitCount - nextRefreshUnitCount + 1L;
        return unitCount * this.unitProduceNum;
    }

    protected void updateNextProduceTime(long currentTimestamp) {
        this.nextProduceTime = this.intervalInMs - (currentTimestamp - this.startTime) % this.intervalInMs + currentTimestamp;
    }

    public long refreshTokenAndGetCurrentTokenNum() {
        this.refreshCurrentTokenNum(TimeUtil.currentTimeMillis());
        return this.currentTokenNum;
    }

    public long getCurrentTokenNum() {
        return this.currentTokenNum;
    }
}

