/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.block.flow.tokenbucket;

import com.alibaba.csp.sentinel.slots.block.flow.tokenbucket.AbstractTokenBucket;
import com.alibaba.csp.sentinel.util.TimeUtil;

public class StrictTokenBucket
extends AbstractTokenBucket {
    private final Object refreshLock = new Object();
    private final Object consumeLock = new Object();

    public StrictTokenBucket(long unitProduceNum, long maxTokenNum, long intervalInMs) {
        super(unitProduceNum, maxTokenNum, false, intervalInMs);
    }

    public StrictTokenBucket(long unitProduceNum, long maxTokenNum, boolean fullStart, long intervalInMs) {
        super(unitProduceNum, maxTokenNum, fullStart, intervalInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryConsume(long tokenNum) {
        if (tokenNum > this.maxTokenNum) {
            return false;
        }
        long currentTimestamp = TimeUtil.currentTimeMillis();
        this.refreshCurrentTokenNum(currentTimestamp);
        if (tokenNum <= this.currentTokenNum) {
            Object object = this.consumeLock;
            synchronized (object) {
                if (tokenNum <= this.currentTokenNum) {
                    this.currentTokenNum -= tokenNum;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshCurrentTokenNum(long currentTimestamp) {
        if (this.nextProduceTime > currentTimestamp) {
            return;
        }
        long producedTokenNum = this.calProducedTokenNum(currentTimestamp);
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.nextProduceTime > currentTimestamp) {
                return;
            }
            this.currentTokenNum = Math.min(this.maxTokenNum, this.currentTokenNum + producedTokenNum);
            this.updateNextProduceTime(currentTimestamp);
        }
    }
}

