/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic;

import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotEntryCallback;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetricStorage;
import com.alibaba.csp.sentinel.slots.statistic.metric.param.ParamsMetricManager;
import com.alibaba.csp.sentinel.util.StringUtil;

public class ParamFlowStatisticEntryCallback
implements ProcessorSlotEntryCallback<DefaultNode> {
    @Override
    public void onPass(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, Object ... args) {
        ParameterMetric parameterMetric = ParameterMetricStorage.getParamMetric(resourceWrapper);
        if (parameterMetric != null) {
            parameterMetric.addThreadCount(args);
        }
    }

    @Override
    public void onBlocked(BlockException ex, Context context, ResourceWrapper resourceWrapper, DefaultNode param, int batchCount, Object ... args) {
        try {
            if (ex instanceof ParamFlowException) {
                ParamFlowRule paramFlowRule = ((ParamFlowException)ex).getRule();
                String key = paramFlowRule.getParamKey();
                Integer index = paramFlowRule.getParamIdx();
                if (StringUtil.isEmpty(key)) {
                    ParamsMetricManager.getInstance().setBlockedParams(resourceWrapper.getName(), String.valueOf(index), batchCount, String.valueOf(args[index]));
                } else {
                    ParamsMetricManager.getInstance().setBlockedParams(resourceWrapper.getName(), key, batchCount, ((ParamFlowException)ex).getLimitParam());
                }
            }
        }
        catch (Throwable e) {
            RecordLog.error("Failed to record parameter block metric for resource {}", resourceWrapper.getName(), e);
        }
    }
}

