/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.metric.param;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import com.alibaba.csp.sentinel.slots.statistic.metric.param.ParamsMetric;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ParamsMetricManager {
    private static volatile ParamsMetricManager paramsMetricManager;
    private static final String PARAM_FILE = "params_metrics.log";
    private final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());
    private static final int KEEP_ALIVE_TIME = 120000;
    private static final int QUEUE_SIZE = 8192;
    private static final int MAX_PARAM_LEN = 200;
    private final ExecutorService paramService;
    private final ExecutorService logService;
    private final ThreadLocal<SimpleDateFormat> commonDateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    private ParamsMetricManager() {
        this.paramService = new ThreadPoolExecutor(1, 1, 120000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(8192), new NamedThreadFactory("sentinel-param-metrics-record-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.logService = new ThreadPoolExecutor(1, 1, 120000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(8192), new NamedThreadFactory("sentinel-params-metrics-log-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParamsMetricManager getInstance() {
        if (paramsMetricManager != null) return paramsMetricManager;
        Class<ParamsMetricManager> clazz = ParamsMetricManager.class;
        synchronized (ParamsMetricManager.class) {
            if (paramsMetricManager != null) return paramsMetricManager;
            paramsMetricManager = new ParamsMetricManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return paramsMetricManager;
        }
    }

    public void setBlockedParams(final String resource, final String index, final int count, final String hotParam) {
        this.paramService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (hotParam == null || hotParam.length() > 200) {
                        RecordLog.warn("[STATIC-PARAM-METRICS] blocked qps with resource: {},index: {}, count: {},hotParam: {} ", resource, count, hotParam, hotParam);
                        return;
                    }
                    ParamsMetric.getInstance().setBlockedQps(resource, index, count, hotParam);
                }
                catch (Throwable e) {
                    RecordLog.warn("[STATIC-PARAM-METRICS] Record blocked param failed, {}, {}, {}, {} ", resource, count, hotParam, e);
                }
            }
        });
    }

    public List<String> getHotParamStatistics() {
        final List<String> hotParams = ParamsMetric.getInstance().getHotParamStatistics();
        this.logService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String paramStr : hotParams) {
                        String[] params = paramStr.split("#");
                        if (params.length == 1) {
                            return;
                        }
                        String rule = params[0];
                        ArrayList<String> paramsList = new ArrayList<String>(params.length);
                        for (int j = 1; j < params.length; ++j) {
                            String[] paramInfo = params[j].split("!");
                            if (paramInfo.length < 3) continue;
                            String hotKey = paramInfo[0];
                            String num = paramInfo[1];
                            String hotString = "key: " + hotKey + ",num:" + num;
                            paramsList.add(hotString);
                        }
                        ParamsMetricManager.this.metricWriter.commonWrite(Collections.singletonList("time: " + ((SimpleDateFormat)ParamsMetricManager.this.commonDateFormatThreadLocal.get()).format(TimeUtil.currentTimeMillis()) + ", rule: " + rule), ParamsMetricManager.PARAM_FILE);
                        ParamsMetricManager.this.metricWriter.commonWrite(paramsList, ParamsMetricManager.PARAM_FILE);
                    }
                }
                catch (Throwable e) {
                    RecordLog.warn("[ClusterMetricManager] Failed to write token metrics on disk", e);
                }
            }
        });
        return hotParams;
    }
}

