/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.stresstest;

import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.stresstest.StressingTestModeConfigManager;
import com.taobao.eagleeye.EagleEye;

public class StressingTestPriorityModeSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    private static boolean eagleEyeExists = false;

    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int batchCount, boolean prioritized, Object ... args) throws Throwable {
        if (!eagleEyeExists) {
            this.fireEntry(context, resourceWrapper, node, batchCount, prioritized, args);
            return;
        }
        boolean realPriority = false;
        if (!prioritized && StressingTestModeConfigManager.isStressTestLowPriorityModeEnabled()) {
            realPriority = !this.isStressingTestRequest();
        }
        this.fireEntry(context, resourceWrapper, node, batchCount, realPriority || prioritized, args);
    }

    private boolean isStressingTestRequest() {
        String tag = EagleEye.getUserData((String)"t");
        return "1".equals(tag) || "2".equals(tag);
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }

    static {
        try {
            Class.forName("com.taobao.eagleeye.EagleEye");
            eagleEyeExists = true;
        }
        catch (Throwable t) {
            RecordLog.warn("[StressingTestPriorityModeSlot] EagleEye does not exist, so this slot will not take effect", new Object[0]);
        }
    }
}

