/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.system;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.metric.extension.MetricExtensionProvider;
import com.alibaba.csp.sentinel.metric.extension.SystemMetricExtension;
import com.alibaba.csp.sentinel.slots.system.SystemMetrics;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import com.alibaba.csp.sentinel.slots.system.metric.ContainerSystemMetricReader;
import com.alibaba.csp.sentinel.slots.system.metric.DefaultSystemMetricReader;
import com.alibaba.csp.sentinel.util.ContainerUtil;
import com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;

public class SystemMetricCollectorTask
implements Runnable {
    private int cpuUsageUpdateIntervalMs = 100;
    private int loadUpdateIntervalMs = 1000;
    private long lastLoadUpdateTimestamp = -1L;
    private final List<SystemMetricExtension> metricExtensions = new ArrayList<SystemMetricExtension>(MetricExtensionProvider.getSystemMetricExtensions());
    private final boolean inContainer;
    private final DefaultSystemMetricReader defaultMetricReader = new DefaultSystemMetricReader();
    private ContainerSystemMetricReader containerMetricReader;

    public SystemMetricCollectorTask() {
        this.inContainer = ContainerUtil.isRunningInContainer();
        if (this.inContainer) {
            this.containerMetricReader = new ContainerSystemMetricReader(this.cpuUsageUpdateIntervalMs);
            this.containerMetricReader.init();
            RecordLog.info("[SystemMetricCollectorTask] Container env detected, using container system metric collector", new Object[0]);
        }
    }

    private double getCpuUsage() {
        if (this.inContainer) {
            return this.containerMetricReader.getCurrentCpuUsage();
        }
        return this.defaultMetricReader.getCurrentCpuUsage();
    }

    @Override
    public void run() {
        while (true) {
            try {
                double currentCpuUsage = this.getCpuUsage();
                if (currentCpuUsage >= 0.0) {
                    SystemMetrics.setCurrentCpuUsage(currentCpuUsage);
                    this.onCpuUsageCollected(currentCpuUsage);
                }
                if (TimeUtil.currentTimeMillis() - this.lastLoadUpdateTimestamp >= (long)this.loadUpdateIntervalMs) {
                    double currentLoad = this.defaultMetricReader.getCurrentSystemLoad1();
                    SystemMetrics.setCurrentSystemLoad(currentLoad);
                    this.lastLoadUpdateTimestamp = TimeUtil.currentTimeMillis();
                    this.onSystemLoadCollected(currentLoad);
                    double loadTrigger = SystemRuleManager.getSystemLoadThreshold();
                    if (loadTrigger >= 0.0 && currentLoad > loadTrigger) {
                        this.writeSystemStatusLog(currentLoad, currentCpuUsage);
                    }
                }
            }
            catch (Throwable e) {
                RecordLog.warn("[SystemMetricCollectorTask] Failed to get system metrics", e);
            }
            SystemMetricCollectorTask.sleepMs(this.cpuUsageUpdateIntervalMs);
        }
    }

    private void onCpuUsageCollected(double cpu) {
        if (this.metricExtensions.isEmpty()) {
            return;
        }
        for (SystemMetricExtension ext : this.metricExtensions) {
            ext.onCpuUsageCollected(cpu);
        }
    }

    private void onSystemLoadCollected(double load) {
        if (this.metricExtensions.isEmpty()) {
            return;
        }
        for (SystemMetricExtension ext : this.metricExtensions) {
            ext.onSystemLoadCollected(load);
        }
    }

    private void writeSystemStatusLog(double load, double cpuUsage) {
        StringBuilder sb = new StringBuilder();
        sb.append("[SystemStatusListener] Load or CPU usage exceeds the threshold: ");
        sb.append("load:").append(String.format("%.4f", load)).append("; ");
        sb.append("cpuUsage:").append(String.format("%.4f", cpuUsage)).append("; ");
        sb.append("passQps:").append(String.format("%.4f", Constants.ENTRY_NODE.passQps())).append("; ");
        sb.append("completeQps:").append(String.format("%.4f", Constants.ENTRY_NODE.successQps())).append("; ");
        sb.append("avgRt:").append(String.format("%.4f", Constants.ENTRY_NODE.avgRt())).append("; ");
        sb.append("concurrency:").append(Constants.ENTRY_NODE.curThreadNum()).append("; ");
        sb.append("minRt:").append(String.format("%.2f", Constants.ENTRY_NODE.minRt())).append("; ");
        sb.append("maxCompleteQps:").append(String.format("%.2f", Constants.ENTRY_NODE.maxSuccessQps()));
        RecordLog.info(sb.toString(), new Object[0]);
    }

    private static void sleepMs(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

