/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.system;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.property.SimplePropertyListener;
import com.alibaba.csp.sentinel.slots.system.SystemMetricType;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SystemRuleManager {
    private static volatile Map<SystemMetricType, SystemRule> ruleMap = new HashMap<SystemMetricType, SystemRule>();
    private static final SystemPropertyListener LISTENER = new SystemPropertyListener();
    private static SentinelProperty<List<SystemRule>> currentProperty = new DynamicSentinelProperty<List<SystemRule>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<SystemRule>> property) {
        SystemPropertyListener systemPropertyListener = LISTENER;
        synchronized (systemPropertyListener) {
            RecordLog.info("[SystemRuleManager] Registering new property to system rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static void loadRules(List<SystemRule> rules) {
        try {
            currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.warn("[SystemRuleManager] Unexpected error when loading system rules", e);
        }
    }

    public static List<SystemRule> getRules() {
        ArrayList<SystemRule> result = new ArrayList<SystemRule>();
        for (Map.Entry<SystemMetricType, SystemRule> e : ruleMap.entrySet()) {
            if (e.getValue() == null) continue;
            result.add(e.getValue());
        }
        return result;
    }

    static Map<SystemMetricType, SystemRule> getRuleMap() {
        return ruleMap;
    }

    public static double getSystemLoadThreshold() {
        SystemRule rule = ruleMap.get((Object)SystemMetricType.LOAD1);
        return rule == null ? -1.0 : rule.getHighestSystemLoad();
    }

    public static double getCpuUsageThreshold() {
        SystemRule rule = ruleMap.get((Object)SystemMetricType.CPU_USAGE);
        return rule == null ? -1.0 : rule.getHighestCpuUsage();
    }

    public static double getInboundQpsThreshold() {
        SystemRule rule = ruleMap.get((Object)SystemMetricType.INBOUND_QPS);
        return rule == null ? Double.MAX_VALUE : rule.getQps();
    }

    public static long getInboundAvgRtThreshold() {
        SystemRule rule = ruleMap.get((Object)SystemMetricType.INBOUND_AVG_RT);
        return rule == null ? Long.MAX_VALUE : rule.getAvgRt();
    }

    public static long getInboundConcurrencyThreshold() {
        SystemRule rule = ruleMap.get((Object)SystemMetricType.INBOUND_CONCURRENCY);
        return rule == null ? Long.MAX_VALUE : rule.getMaxThread();
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    static class SystemPropertyListener
    extends SimplePropertyListener<List<SystemRule>> {
        SystemPropertyListener() {
        }

        private Map<SystemMetricType, SystemRule> generateMap(List<SystemRule> rules) {
            HashMap<SystemMetricType, SystemRule> map = new HashMap<SystemMetricType, SystemRule>(4);
            if (rules == null || rules.isEmpty()) {
                return map;
            }
            for (SystemRule rule : rules) {
                double newCpu;
                double newLoad1;
                double newInboundQps;
                long newMaxConcurrency;
                long newAvgRt = rule.getAvgRt();
                if (newAvgRt >= 0L) {
                    SystemRule cur = (SystemRule)map.get((Object)SystemMetricType.INBOUND_AVG_RT);
                    if (cur == null) {
                        map.put(SystemMetricType.INBOUND_AVG_RT, new SystemRule().setAvgRt(newAvgRt));
                    } else if (newAvgRt < cur.getAvgRt()) {
                        cur.setAvgRt(newAvgRt);
                    }
                }
                if ((newMaxConcurrency = rule.getMaxThread()) >= 0L) {
                    SystemRule cur = (SystemRule)map.get((Object)SystemMetricType.INBOUND_CONCURRENCY);
                    if (cur == null) {
                        map.put(SystemMetricType.INBOUND_CONCURRENCY, new SystemRule().setMaxThread(newMaxConcurrency));
                    } else if (newMaxConcurrency < cur.getMaxThread()) {
                        cur.setMaxThread(newMaxConcurrency);
                    }
                }
                if ((newInboundQps = rule.getQps()) >= 0.0) {
                    SystemRule cur = (SystemRule)map.get((Object)SystemMetricType.INBOUND_QPS);
                    if (cur == null) {
                        map.put(SystemMetricType.INBOUND_QPS, new SystemRule().setQps(newInboundQps));
                    } else if (newInboundQps < cur.getQps()) {
                        cur.setQps(newInboundQps);
                    }
                }
                if ((newLoad1 = rule.getHighestSystemLoad()) >= 0.0) {
                    SystemRule cur = (SystemRule)map.get((Object)SystemMetricType.LOAD1);
                    if (cur == null) {
                        map.put(SystemMetricType.LOAD1, new SystemRule().setHighestSystemLoad(newLoad1));
                    } else if (newLoad1 < cur.getHighestSystemLoad()) {
                        cur.setHighestSystemLoad(newLoad1);
                    }
                }
                if (!((newCpu = rule.getHighestCpuUsage()) >= 0.0)) continue;
                if (newCpu > 1.0) {
                    RecordLog.warn(String.format("[SystemRuleManager] Ignoring invalid SystemRule: highestCpuUsage %.3f > 1", newCpu), new Object[0]);
                    continue;
                }
                SystemRule cur = (SystemRule)map.get((Object)SystemMetricType.CPU_USAGE);
                if (cur == null) {
                    map.put(SystemMetricType.CPU_USAGE, rule);
                    continue;
                }
                if (!(newCpu < cur.getHighestCpuUsage())) continue;
                cur.setHighestCpuUsage(newCpu);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configUpdate(List<SystemRule> rules) {
            Map<SystemMetricType, SystemRule> map = this.generateMap(rules);
            SystemPropertyListener systemPropertyListener = this;
            synchronized (systemPropertyListener) {
                ruleMap = map;
            }
            RecordLog.info("[SystemRuleManager] System rule loaded: " + map.toString(), new Object[0]);
        }
    }
}

