/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.system;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adaptive.SystemAdaptiveThrottler;
import com.alibaba.csp.sentinel.adaptive.config.AdaptiveFlowSettingManager;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import com.alibaba.csp.sentinel.slots.system.SystemMetricType;
import com.alibaba.csp.sentinel.slots.system.SystemMetrics;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.alibaba.csp.sentinel.slots.system.SystemRuleManager;
import java.util.Map;

public class SystemSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        this.checkSystemRules(resourceWrapper);
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    private void checkSystemRules(ResourceWrapper rw) throws BlockException {
        if (rw == null || rw.getEntryType() != EntryType.IN) {
            return;
        }
        if (AdaptiveFlowSettingManager.isAutoSystemAdaptiveEnabled()) {
            this.checkCpuAdaptive(0.6, rw.getName());
        } else {
            Map<SystemMetricType, SystemRule> ruleMap = SystemRuleManager.getRuleMap();
            if (ruleMap.isEmpty()) {
                return;
            }
            for (Map.Entry<SystemMetricType, SystemRule> e : ruleMap.entrySet()) {
                this.checkRule(e.getKey(), e.getValue(), rw);
            }
        }
    }

    private void checkCpuAdaptive(double threshold, String resource) throws BlockException {
        if (SystemMetrics.getCurrentCpuUsage() > threshold && !SystemAdaptiveThrottler.canPass()) {
            throw new SystemBlockException(resource, "cpu");
        }
    }

    private void checkRule(SystemMetricType metricType, SystemRule rule, ResourceWrapper rw) throws BlockException {
        ClusterNode inboundNode = Constants.ENTRY_NODE;
        switch (metricType) {
            case INBOUND_QPS: {
                if (inboundNode.passQps() > rule.getQps()) {
                    throw new SystemBlockException(rw.getName(), "qps", rule);
                }
                return;
            }
            case INBOUND_AVG_RT: {
                if (inboundNode.avgRt() > (double)rule.getAvgRt()) {
                    throw new SystemBlockException(rw.getName(), "rt", rule);
                }
                return;
            }
            case INBOUND_CONCURRENCY: {
                if ((long)inboundNode.curThreadNum() > rule.getMaxThread()) {
                    throw new SystemBlockException(rw.getName(), "concurrency", rule);
                }
                return;
            }
            case LOAD1: {
                if (SystemMetrics.getCurrentSystemLoad() > rule.getHighestSystemLoad() && !SystemSlot.canPassBbr(inboundNode)) {
                    throw new SystemBlockException(rw.getName(), "load", rule);
                }
                return;
            }
            case CPU_USAGE: {
                if (SystemMetrics.getCurrentCpuUsage() > rule.getHighestCpuUsage() && !SystemAdaptiveThrottler.canPass()) {
                    throw new SystemBlockException(rw.getName(), "cpu", rule);
                }
                return;
            }
        }
    }

    private static boolean canPassBbr(ClusterNode inboundNode) {
        int curConcurrency = inboundNode.curThreadNum();
        return curConcurrency <= 1 || !((double)curConcurrency > inboundNode.maxSuccessQps() * inboundNode.minRt() / 1000.0);
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }
}

