/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.system.metric;

import com.alibaba.csp.sentinel.util.VersionUtil;
import com.jezhumble.javasysmon.CpuTimes;
import com.jezhumble.javasysmon.JavaSysMon;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public class DefaultSystemMetricReader {
    private JavaSysMon monitor;
    private CpuTimes lastCpuTimes;
    private final java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    private Object sunOsBean;

    public DefaultSystemMetricReader() {
        if (VersionUtil.isJdk7OrHigher()) {
            this.sunOsBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        } else {
            this.monitor = new JavaSysMon();
            this.lastCpuTimes = this.monitor.cpuTimes();
        }
    }

    public double getCurrentCpuUsage() {
        if (this.sunOsBean != null) {
            return ((OperatingSystemMXBean)this.sunOsBean).getSystemCpuLoad();
        }
        CpuTimes cpuTimes = this.monitor.cpuTimes();
        double res = cpuTimes.getCpuUsage(this.lastCpuTimes);
        this.lastCpuTimes = cpuTimes;
        return res;
    }

    public double getCurrentSystemLoad1() {
        return this.osBean.getSystemLoadAverage();
    }
}

