/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.command;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.sentinel.log.CommandCenterLog;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.mesh.AliMeshSentinelStatusManager;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpClient;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpRequest;
import com.alibaba.csp.sentinel.transport.heartbeat.client.SimpleHttpResponse;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.ConnectException;
import java.net.InetSocketAddress;

public class AliMeshSentinelDetector {
    private static final String ENABLED_KEY = "enabled";
    private static final String VERSION_KEY = "version";
    public static final String MESH_PLUGIN_STATUS_PATH = "/mesh/pluginStatus";
    public static final int DEFAULT_MESH_SENTINEL_PORT = 8717;
    public static final String SENTINEL_MESH_VERSION_POSTFIX = "-MESH";
    public static final int DEFAULT_DETECT_PERIOD_MS = 60000;
    private final SimpleHttpClient client = new SimpleHttpClient();
    private Thread detectTask;

    public synchronized void startDetectTask() {
        if (this.detectTask == null) {
            this.detectTask = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                boolean prevStatus;
                                boolean curStatus;
                                if ((curStatus = AliMeshSentinelDetector.this.isMeshPluginEnabled()) != (prevStatus = AliMeshSentinelStatusManager.isMeshSentinelEnabled())) {
                                    AliMeshSentinelStatusManager.setMeshSentinelEnabled(curStatus);
                                    RecordLog.info("[AliMeshSentinelDetector] Mesh Sentinel plugin enabled status has been updated to " + curStatus, new Object[0]);
                                }
                                Thread.sleep(60000L);
                            }
                        }
                        catch (InterruptedException ex) {
                            RecordLog.warn("[AliMeshSentinelDetector] Detector task is interrupted", new Object[0]);
                            return;
                        }
                        catch (Exception ex) {
                            RecordLog.warn("[AliMeshSentinelDetector] Failed to detect Mesh Sentinel plugin", ex);
                            continue;
                        }
                        break;
                    }
                }
            });
            this.detectTask.setDaemon(true);
            this.detectTask.setName("sentinel-mesh-plugin-detector-task");
            this.detectTask.start();
        }
    }

    public synchronized void stopDetectTask() {
        if (this.detectTask != null) {
            this.detectTask.interrupt();
            this.detectTask = null;
            RecordLog.info("[AliMeshSentinelDetector] Mesh detector task stopped", new Object[0]);
        }
    }

    public String tryGetMeshSentinelVersion() {
        try {
            InetSocketAddress addr = new InetSocketAddress("localhost", 8717);
            SimpleHttpRequest request = new SimpleHttpRequest(addr, "/version").setSoTimeout(500);
            SimpleHttpResponse response = this.client.get(request);
            if (response == null || response.getBody() == null) {
                return null;
            }
            return response.getBodyAsString();
        }
        catch (Exception ex) {
            if (ex instanceof ConnectException && ex.getMessage() != null && ex.getMessage().contains("Connection refused")) {
                RecordLog.info("AliMesh Sentinel port 8717 not detected", new Object[0]);
                return null;
            }
            CommandCenterLog.warn("Failed to detect AliMesh Sentinel", ex);
            return null;
        }
    }

    public boolean isMeshPluginEnabled() {
        try {
            InetSocketAddress addr = new InetSocketAddress("localhost", 8717);
            SimpleHttpRequest request = new SimpleHttpRequest(addr, MESH_PLUGIN_STATUS_PATH).setSoTimeout(500);
            SimpleHttpResponse response = this.client.get(request);
            if (response == null || response.getBody() == null) {
                return false;
            }
            if (!AliMeshSentinelDetector.equals(response.getStatusCode(), 200)) {
                return false;
            }
            JSONObject obj = JSON.parseObject(response.getBodyAsString());
            if (obj == null || !obj.containsKey(ENABLED_KEY)) {
                return false;
            }
            String meshSentinelVersion = obj.getString(VERSION_KEY);
            if (!AliMeshSentinelDetector.isSentinelVersionForMesh(meshSentinelVersion)) {
                return false;
            }
            return AliMeshSentinelDetector.equals(obj.getBoolean(ENABLED_KEY), true);
        }
        catch (Exception ex) {
            if (ex instanceof ConnectException && ex.getMessage() != null && ex.getMessage().startsWith("Connection refused")) {
                return false;
            }
            return false;
        }
    }

    public static boolean isSentinelVersionForMesh(String sentinelVersion) {
        return !StringUtil.isBlank(sentinelVersion) && sentinelVersion.endsWith(SENTINEL_MESH_VERSION_POSTFIX);
    }

    private static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

