/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.init;

import com.alibaba.csp.sentinel.command.AliMetricsBootstrap;
import com.alibaba.csp.sentinel.command.CommandCenterProvider;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.CommandCenter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@InitOrder(value=-1)
public class CommandCenterInitFunc
implements InitFunc {
    private final ExecutorService pool = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new NamedThreadFactory("sentinel-command-center-init-async-pool", true));

    @Override
    public void init() throws Exception {
        this.pool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AliMetricsBootstrap.init();
                }
                catch (Throwable e) {
                    RecordLog.warn("[CommandCenterInitFunc] ERROR: Ali-metrics init error", e);
                }
            }
        });
        CommandCenter commandCenter = CommandCenterProvider.getCommandCenter();
        if (commandCenter == null) {
            RecordLog.warn("[CommandCenterInitFunc] Active CommandCenter not found", new Object[0]);
            return;
        }
        commandCenter.beforeStart();
        commandCenter.start();
        RecordLog.info("[CommandCenterInit] Starting command center: " + commandCenter.getClass().getCanonicalName(), new Object[0]);
    }
}

