/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.init;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.heartbeat.HeartbeatSenderProvider;
import com.alibaba.csp.sentinel.init.InitFunc;
import com.alibaba.csp.sentinel.init.InitOrder;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.transport.HeartbeatSender;
import com.alibaba.csp.sentinel.transport.config.TransportConfig;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@InitOrder(value=-1)
public class HeartbeatSenderInitFunc
implements InitFunc {
    private ScheduledExecutorService pool = null;

    private void initSchedulerIfNeeded() {
        if (this.pool == null) {
            this.pool = new ScheduledThreadPoolExecutor(2, new NamedThreadFactory("sentinel-heartbeat-send-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
    }

    @Override
    public void init() {
        HeartbeatSender sender = HeartbeatSenderProvider.getHeartbeatSender();
        if (sender == null) {
            RecordLog.warn("[HeartbeatSenderInitFunc] WARN: No HeartbeatSender loaded", new Object[0]);
            return;
        }
        long interval = this.retrieveInterval(sender);
        if (interval > 0L) {
            this.initSchedulerIfNeeded();
            this.setIntervalIfNotExists(interval);
            this.scheduleHeartbeatTask(sender, interval);
        }
    }

    private boolean isValidHeartbeatInterval(Long interval) {
        return interval != null && interval > 0L;
    }

    private void setIntervalIfNotExists(long interval) {
        SentinelConfig.setConfig("csp.sentinel.heartbeat.interval.ms", String.valueOf(interval));
    }

    long retrieveInterval(HeartbeatSender sender) {
        Long intervalInConfig = TransportConfig.getHeartbeatIntervalMs();
        if (this.isValidHeartbeatInterval(intervalInConfig)) {
            RecordLog.info("[HeartbeatSenderInitFunc] Using heartbeat interval in Sentinel config property: " + intervalInConfig, new Object[0]);
            return intervalInConfig;
        }
        long senderInterval = sender.intervalMs();
        if (senderInterval >= 0L) {
            RecordLog.info("[HeartbeatSenderInit] Heartbeat interval not configured in config property or invalid, using sender default: " + senderInterval, new Object[0]);
        } else {
            RecordLog.info("[HeartbeatSenderInit] Heartbeat interval <= 0, task will not be started", new Object[0]);
        }
        return senderInterval;
    }

    private void scheduleHeartbeatTask(final HeartbeatSender sender, long interval) {
        this.pool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    sender.sendHeartbeat();
                }
                catch (Throwable e) {
                    RecordLog.warn("[HeartbeatSender] Send heartbeat error", e);
                }
            }
        }, 5000L, interval, TimeUnit.MILLISECONDS);
        RecordLog.info("[HeartbeatSenderInit] HeartbeatSender started: " + sender.getClass().getCanonicalName(), new Object[0]);
    }
}

