/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.util;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.spi.ServiceLoaderUtil;
import com.alibaba.csp.sentinel.spi.SpiOrder;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class SpiLoader {
    public static final Set<String> SENTINEL_INTERNAL_PACKAGE_SET = new HashSet<String>(Arrays.asList("com.alibaba.csp.sentinel", "com.taobao.csp.sentinel", "com.alibaba.csp.ahas.sentinel"));
    private static final ConcurrentHashMap<Class<?>, Map<String, Class<?>>> SPI_IMPL_CLASS_MAP = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, List<Object>> SERVICE_INSTANCE_CACHE = new ConcurrentHashMap();

    public static <T> T loadFirstInstance(Class<T> clazz) {
        AssertUtil.notNull(clazz, "SPI class cannot be null");
        return SpiLoader.loadHighestPriorityInstance(clazz);
    }

    public static <T> T loadFirstInstanceOrDefault(Class<T> clazz, Class<? extends T> defaultClass) {
        AssertUtil.notNull(clazz, "SPI class cannot be null");
        AssertUtil.notNull(defaultClass, "default SPI class cannot be null");
        try {
            List<T> instanceList = SpiLoader.loadInstanceListSorted(clazz);
            if (CollectionUtil.isEmpty(instanceList)) {
                return null;
            }
            for (T inst : instanceList) {
                if (inst.getClass() == defaultClass) continue;
                return inst;
            }
            return defaultClass.newInstance();
        }
        catch (Throwable t) {
            RecordLog.error("[SpiLoader] ERROR: loadFirstInstanceOrDefault failed", t);
            return null;
        }
    }

    public static <T> T loadHighestPriorityInstance(Class<T> clazz) {
        AssertUtil.notNull(clazz, "SPI class cannot be null");
        try {
            List<T> instanceList = SpiLoader.loadInstanceListSorted(clazz);
            if (CollectionUtil.isEmpty(instanceList)) {
                return null;
            }
            return instanceList.get(0);
        }
        catch (Throwable t) {
            RecordLog.error("[SpiLoader] ERROR: loadHighestPriorityInstance failed", t);
            return null;
        }
    }

    public static synchronized <T> List<T> loadInstanceList(Class<T> clazz) {
        try {
            if (!SPI_IMPL_CLASS_MAP.containsKey(clazz)) {
                ClassLoader targetClassLoader = ServiceLoaderUtil.getTargetClassLoader(clazz);
                Map<String, Class<?>> implClassMap = ServiceLoaderUtil.findImplClasses(clazz, targetClassLoader);
                ClassLoader appContextClassLoader = ServiceLoaderUtil.getAppContextClassLoader();
                if (appContextClassLoader != null && appContextClassLoader != clazz.getClassLoader()) {
                    Map<String, Class<?>> mapOfAccl = ServiceLoaderUtil.findImplClasses(clazz, appContextClassLoader, SENTINEL_INTERNAL_PACKAGE_SET);
                    implClassMap.putAll(mapOfAccl);
                }
                HashMap classMap = new HashMap(implClassMap);
                ArrayList orderWrappers = new ArrayList();
                for (Map.Entry<String, Class<?>> e : implClassMap.entrySet()) {
                    T instance = clazz.cast(e.getValue().newInstance());
                    int order = SpiOrderResolver.resolveOrder(instance);
                    SpiOrderResolver.insertSorted(orderWrappers, instance, order);
                    RecordLog.info("[SpiLoader] Found {} SPI: {} with order " + order, clazz.getSimpleName(), e.getValue().getCanonicalName());
                }
                ArrayList<Object> instanceList = new ArrayList<Object>();
                for (int i = 0; i < orderWrappers.size(); ++i) {
                    instanceList.add(i, ((SpiOrderWrapper)orderWrappers.get(i)).spi);
                }
                SPI_IMPL_CLASS_MAP.put(clazz, classMap);
                SERVICE_INSTANCE_CACHE.put(clazz, instanceList);
                return instanceList;
            }
            return (List)SERVICE_INSTANCE_CACHE.get(clazz);
        }
        catch (Throwable t) {
            RecordLog.error("[SpiLoader] ERROR: loadInstanceList failed", t);
            t.printStackTrace();
            return new ArrayList();
        }
    }

    public static <T> List<T> loadInstanceListSorted(Class<T> clazz) {
        return SpiLoader.loadInstanceList(clazz);
    }

    public static boolean isSentinelInternalPackage(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        for (String packagePrefix : SENTINEL_INTERNAL_PACKAGE_SET) {
            if (!className.startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    private SpiLoader() {
    }

    private static class SpiOrderWrapper<T> {
        private final int order;
        private final T spi;

        SpiOrderWrapper(int order, T spi) {
            this.order = order;
            this.spi = spi;
        }

        int getOrder() {
            return this.order;
        }

        T getSpi() {
            return this.spi;
        }
    }

    private static class SpiOrderResolver {
        private SpiOrderResolver() {
        }

        private static <T> void insertSorted(List<SpiOrderWrapper<T>> list, T spi, int order) {
            int idx;
            for (idx = 0; idx < list.size() && list.get(idx).getOrder() <= order; ++idx) {
            }
            list.add(idx, new SpiOrderWrapper<T>(order, spi));
        }

        private static <T> int resolveOrder(T spi) {
            if (!spi.getClass().isAnnotationPresent(SpiOrder.class)) {
                return Integer.MAX_VALUE;
            }
            return spi.getClass().getAnnotation(SpiOrder.class).value();
        }
    }
}

