/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.web.adapter.common.api;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import com.alibaba.csp.sentinel.web.adapter.common.api.ApiDefinition;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractCommonApiMatcher<T>
implements Predicate<T> {
    protected final String apiName;
    protected final ApiDefinition apiDefinition;
    protected final Set<Predicate<T>> matchers = new HashSet<Predicate<T>>();

    public AbstractCommonApiMatcher(ApiDefinition apiDefinition) {
        AssertUtil.notNull(apiDefinition, "apiDefinition cannot be null");
        AssertUtil.assertNotBlank(apiDefinition.getApiName(), "apiName cannot be empty");
        this.apiName = apiDefinition.getApiName();
        this.apiDefinition = apiDefinition;
        try {
            this.initializeMatchers();
        }
        catch (Exception ex) {
            RecordLog.warn("[WebParamApiMatcher] Failed to initialize internal matchers", ex);
        }
    }

    protected abstract void initializeMatchers();

    @Override
    public boolean test(T t) {
        for (Predicate<T> matcher : this.matchers) {
            if (!matcher.test(t)) continue;
            return true;
        }
        return false;
    }

    public String getApiName() {
        return this.apiName;
    }

    public ApiDefinition getApiDefinition() {
        return this.apiDefinition;
    }
}

