/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.web.adapter.common.api;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import com.alibaba.csp.sentinel.web.adapter.common.api.AbstractCommonApiMatcher;
import com.alibaba.csp.sentinel.web.adapter.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.web.adapter.common.api.ApiPredicateItem;
import com.alibaba.csp.sentinel.web.adapter.common.api.WebApiPathPredicateItem;
import com.alibaba.csp.sentinel.web.adapter.common.route.WebRouteMatchers;
import javax.servlet.http.HttpServletRequest;

public class WebParamApiMatcher
extends AbstractCommonApiMatcher<HttpServletRequest> {
    public WebParamApiMatcher(ApiDefinition apiDefinition) {
        super(apiDefinition);
    }

    @Override
    protected void initializeMatchers() {
        if (this.apiDefinition.getPredicateItems() != null) {
            for (ApiPredicateItem item : this.apiDefinition.getPredicateItems()) {
                Predicate<HttpServletRequest> predicate = this.fromApiPredicate(item);
                if (predicate == null) continue;
                this.matchers.add(predicate);
            }
        }
    }

    private Predicate<HttpServletRequest> fromApiPredicate(ApiPredicateItem item) {
        if (item instanceof WebApiPathPredicateItem) {
            return this.fromApiPathPredicate((WebApiPathPredicateItem)item);
        }
        return null;
    }

    private Predicate<HttpServletRequest> fromApiPathPredicate(WebApiPathPredicateItem item) {
        String pattern = item.getPattern();
        if (StringUtil.isBlank(pattern)) {
            return null;
        }
        try {
            switch (item.getMatchStrategy()) {
                case 2: {
                    return WebRouteMatchers.regexPath(pattern);
                }
                case 1: {
                    return WebRouteMatchers.antPath(pattern);
                }
            }
            return WebRouteMatchers.exactPath(pattern);
        }
        catch (Exception ex) {
            RecordLog.error("Failed to create route matcher for API group pattern: " + item.toString(), ex);
            return null;
        }
    }
}

