/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.web.adapter.common.route;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import com.alibaba.csp.sentinel.web.adapter.common.route.WebServletUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class WebPrefixRoutePathMatcher
implements Predicate<HttpServletRequest> {
    private final String pattern;
    private final PathMatcher pathMatcher;
    private final boolean canMatch;

    public WebPrefixRoutePathMatcher(String pattern) {
        AssertUtil.assertNotBlank(pattern, "pattern cannot be blank");
        this.pattern = pattern;
        this.pathMatcher = new AntPathMatcher();
        this.canMatch = this.pathMatcher.isPattern(pattern);
    }

    @Override
    public boolean test(HttpServletRequest request) {
        if (!this.canMatch) {
            return false;
        }
        String path = WebServletUtils.getPath(request);
        return this.pathMatcher.match(this.pattern, path);
    }

    public String getPattern() {
        return this.pattern;
    }
}

