/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.web.adapter.common.route;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import com.alibaba.csp.sentinel.web.adapter.common.route.WebServletUtils;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class WebRegexRoutePathMatcher
implements Predicate<HttpServletRequest> {
    private final String pattern;
    private final Pattern regex;

    public WebRegexRoutePathMatcher(String pattern) {
        AssertUtil.assertNotBlank(pattern, "pattern cannot be blank");
        this.pattern = pattern;
        this.regex = Pattern.compile(pattern);
    }

    @Override
    public boolean test(HttpServletRequest request) {
        String path = WebServletUtils.getPath(request);
        return this.regex.matcher(path).matches();
    }

    public String getPattern() {
        return this.pattern;
    }
}

