/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.web.adapter.common.route;

import com.alibaba.csp.sentinel.util.function.Predicate;
import com.alibaba.csp.sentinel.web.adapter.common.route.WebPrefixRoutePathMatcher;
import com.alibaba.csp.sentinel.web.adapter.common.route.WebRegexRoutePathMatcher;
import com.alibaba.csp.sentinel.web.adapter.common.route.WebServletUtils;
import javax.servlet.http.HttpServletRequest;

public final class WebRouteMatchers {
    public static Predicate<HttpServletRequest> all() {
        return new Predicate<HttpServletRequest>(){

            @Override
            public boolean test(HttpServletRequest requestContext) {
                return true;
            }
        };
    }

    public static Predicate<HttpServletRequest> antPath(String pathPattern) {
        return new WebPrefixRoutePathMatcher(pathPattern);
    }

    public static Predicate<HttpServletRequest> exactPath(final String path) {
        return new Predicate<HttpServletRequest>(){

            @Override
            public boolean test(HttpServletRequest request) {
                return WebServletUtils.getPath(request).equals(path);
            }
        };
    }

    public static Predicate<HttpServletRequest> regexPath(String pathPattern) {
        return new WebRegexRoutePathMatcher(pathPattern);
    }

    private WebRouteMatchers() {
    }
}

