/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.web.adapter.common.rule;

import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowClusterConfig;
import com.alibaba.csp.sentinel.web.adapter.common.rule.WebParamItem;

public class WebFlowRule {
    private Long id;
    private String resource;
    private int resourceMode = 0;
    private int grade = 1;
    private double count;
    private long intervalMs = 1000L;
    private int controlBehavior = 0;
    private int burst;
    private int maxQueueingTimeoutMs = 500;
    private WebParamItem paramItem;
    private boolean clusterMode = false;
    private ParamFlowClusterConfig clusterConfig;

    public WebFlowRule() {
    }

    public WebFlowRule(String resource) {
        this.resource = resource;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getResource() {
        return this.resource;
    }

    public WebFlowRule setResource(String resource) {
        this.resource = resource;
        return this;
    }

    public int getResourceMode() {
        return this.resourceMode;
    }

    public WebFlowRule setResourceMode(int resourceMode) {
        this.resourceMode = resourceMode;
        return this;
    }

    public int getControlBehavior() {
        return this.controlBehavior;
    }

    public WebFlowRule setControlBehavior(int controlBehavior) {
        this.controlBehavior = controlBehavior;
        return this;
    }

    public double getCount() {
        return this.count;
    }

    public WebFlowRule setCount(double count) {
        this.count = count;
        return this;
    }

    public long getIntervalMs() {
        return this.intervalMs;
    }

    public WebFlowRule setIntervalMs(long intervalMs) {
        this.intervalMs = intervalMs;
        return this;
    }

    public WebParamItem getParamItem() {
        return this.paramItem;
    }

    public WebFlowRule setParamItem(WebParamItem paramItem) {
        this.paramItem = paramItem;
        return this;
    }

    public int getMaxQueueingTimeoutMs() {
        return this.maxQueueingTimeoutMs;
    }

    public WebFlowRule setMaxQueueingTimeoutMs(int maxQueueingTimeoutMs) {
        this.maxQueueingTimeoutMs = maxQueueingTimeoutMs;
        return this;
    }

    public int getGrade() {
        return this.grade;
    }

    public void setGrade(int grade) {
        this.grade = grade;
    }

    public int getBurst() {
        return this.burst;
    }

    public WebFlowRule setBurst(int burst) {
        this.burst = burst;
        return this;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    public void setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
    }

    public ParamFlowClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public void setClusterConfig(ParamFlowClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebFlowRule that = (WebFlowRule)o;
        if (this.resourceMode != that.resourceMode) {
            return false;
        }
        if (this.grade != that.grade) {
            return false;
        }
        if (Double.compare(that.count, this.count) != 0) {
            return false;
        }
        if (this.intervalMs != that.intervalMs) {
            return false;
        }
        if (this.controlBehavior != that.controlBehavior) {
            return false;
        }
        if (this.burst != that.burst) {
            return false;
        }
        if (this.maxQueueingTimeoutMs != that.maxQueueingTimeoutMs) {
            return false;
        }
        if (this.resource != null ? !this.resource.equals(that.resource) : that.resource != null) {
            return false;
        }
        return this.paramItem != null ? this.paramItem.equals(that.paramItem) : that.paramItem == null;
    }

    public int hashCode() {
        int result = this.resource != null ? this.resource.hashCode() : 0;
        result = 31 * result + this.resourceMode;
        result = 31 * result + this.grade;
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.intervalMs ^ this.intervalMs >>> 32);
        result = 31 * result + this.controlBehavior;
        result = 31 * result + this.burst;
        result = 31 * result + this.maxQueueingTimeoutMs;
        result = 31 * result + (this.paramItem != null ? this.paramItem.hashCode() : 0);
        result = 31 * result + (this.clusterMode ? 1 : 0);
        result = 31 * result + (this.clusterConfig != null ? this.clusterConfig.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WebFlowRule{resource='" + this.resource + '\'' + ", resourceMode=" + this.resourceMode + ", grade=" + this.grade + ", count=" + this.count + ", intervalMs=" + this.intervalMs + ", controlBehavior=" + this.controlBehavior + ", burst=" + this.burst + ", maxQueueingTimeoutMs=" + this.maxQueueingTimeoutMs + ", paramItem=" + this.paramItem + ", clusterMode=" + this.clusterMode + ", clusterConfig=" + this.clusterConfig + '}';
    }
}

