/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.datasource;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.taobao.csp.sentinel.slots.block.authority.AuthorityRule;
import com.taobao.csp.sentinel.util.LegacyRuleConvertUtils;
import com.taobao.csp.sentinel.util.MachineGroupUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LegacyAuthorityRuleParser
implements Converter<String, List<com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule>> {
    @Override
    public List<com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule> convert(String source) {
        if (StringUtil.isEmpty(source)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject(source);
        String ruleConf = jsonObject.getObject("data", String.class);
        if (StringUtil.isEmpty(ruleConf)) {
            return null;
        }
        List<AuthorityRule> oldRules = JSONObject.parseObject(ruleConf, new TypeReference<List<AuthorityRule>>(){}, Feature.IgnoreNotMatch);
        if (oldRules == null) {
            return null;
        }
        HashMap<String, ArrayList<AuthorityRule>> map = new HashMap<String, ArrayList<AuthorityRule>>(16);
        for (AuthorityRule oldRule : oldRules) {
            ArrayList<AuthorityRule> list = (ArrayList<AuthorityRule>)map.get(oldRule.getIdentity());
            if (list == null) {
                list = new ArrayList<AuthorityRule>(4);
                map.put(oldRule.getIdentity(), list);
            }
            list.add(oldRule);
        }
        ArrayList<com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule> rules = new ArrayList<com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule>(oldRules.size());
        String machineGroup = MachineGroupUtil.getGroupNameOfThisMachine();
        for (Map.Entry entry : map.entrySet()) {
            HashSet<String> groupSet = new HashSet<String>();
            for (AuthorityRule oldRule : (List)entry.getValue()) {
                if (!StringUtil.isNotBlank(oldRule.getGroup())) continue;
                groupSet.add(oldRule.getGroup());
            }
            for (AuthorityRule oldRule : (List)entry.getValue()) {
                if (!MachineGroupUtil.checkRuleGroup(machineGroup, oldRule.getGroup(), groupSet)) continue;
                rules.add(LegacyRuleConvertUtils.convertAuthorityRule(oldRule));
            }
        }
        return rules;
    }
}

