/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.datasource;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Function;
import com.taobao.csp.sentinel.slots.block.degrade.DegrateRule;
import com.taobao.csp.sentinel.util.LegacyRuleConvertUtils;
import com.taobao.csp.sentinel.util.MachineGroupUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LegacyDegradeRuleParser
implements Converter<String, List<DegradeRule>> {
    private static volatile Function<List<DegradeRule>, List<DegradeRule>> ruleTransformer = null;

    @Override
    public List<DegradeRule> convert(String source) {
        if (StringUtil.isEmpty(source)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject(source);
        String ruleConf = jsonObject.getObject("data", String.class);
        if (StringUtil.isEmpty(ruleConf)) {
            return null;
        }
        List<DegrateRule> oldRules = JSONObject.parseObject(ruleConf, new TypeReference<List<DegrateRule>>(){}, Feature.IgnoreNotMatch);
        if (oldRules == null) {
            return null;
        }
        HashMap<String, ArrayList<DegrateRule>> map = new HashMap<String, ArrayList<DegrateRule>>(16);
        for (DegrateRule oldRule : oldRules) {
            ArrayList<DegrateRule> list = (ArrayList<DegrateRule>)map.get(oldRule.getIdentity());
            if (list == null) {
                list = new ArrayList<DegrateRule>(4);
                map.put(oldRule.getIdentity(), list);
            }
            list.add(oldRule);
        }
        List<DegradeRule> rules = new ArrayList<DegradeRule>(oldRules.size());
        String machineGroup = MachineGroupUtil.getGroupNameOfThisMachine();
        for (Map.Entry entry : map.entrySet()) {
            HashSet<String> groupSet = new HashSet<String>();
            for (DegrateRule oldRule : (List)entry.getValue()) {
                if (!StringUtil.isNotBlank(oldRule.getGroup())) continue;
                groupSet.add(oldRule.getGroup());
            }
            for (DegrateRule oldRule : (List)entry.getValue()) {
                if (!MachineGroupUtil.checkRuleGroup(machineGroup, oldRule.getGroup(), groupSet)) continue;
                rules.add(LegacyRuleConvertUtils.convertDegradeRule(oldRule));
            }
        }
        if (ruleTransformer != null) {
            rules = ruleTransformer.apply(rules);
        }
        return rules;
    }

    public static void setRuleTransformer(Function<List<DegradeRule>, List<DegradeRule>> ruleTransformer) {
        LegacyDegradeRuleParser.ruleTransformer = ruleTransformer;
    }
}

