/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.datasource;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.csp.sentinel.util.function.Function;
import com.taobao.csp.sentinel.slots.block.flow.FlowRule;
import com.taobao.csp.sentinel.util.LegacyRuleConvertUtils;
import com.taobao.csp.sentinel.util.MachineGroupUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LegacyFlowRuleParser
implements Converter<String, List<com.alibaba.csp.sentinel.slots.block.flow.FlowRule>> {
    private static volatile Function<List<com.alibaba.csp.sentinel.slots.block.flow.FlowRule>, List<com.alibaba.csp.sentinel.slots.block.flow.FlowRule>> ruleTransformer = null;
    private final boolean filterGroup;

    public LegacyFlowRuleParser() {
        this(true);
    }

    public LegacyFlowRuleParser(boolean filterGroup) {
        this.filterGroup = filterGroup;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<com.alibaba.csp.sentinel.slots.block.flow.FlowRule> convert(String source) {
        if (StringUtil.isEmpty(source)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject(source);
        String ruleConf = jsonObject.getObject("data", String.class);
        if (StringUtil.isEmpty(ruleConf)) {
            return null;
        }
        List<FlowRule> oldRules = JSONObject.parseObject(ruleConf, new TypeReference<List<FlowRule>>(){}, Feature.IgnoreNotMatch);
        if (oldRules == null) {
            return null;
        }
        HashMap map = new HashMap(16);
        for (FlowRule flowRule : oldRules) {
            void var8_10;
            List list = (List)map.get(flowRule.getIdentity());
            if (list == null) {
                ArrayList arrayList = new ArrayList(4);
                map.put(flowRule.getIdentity(), arrayList);
            }
            var8_10.add(flowRule);
        }
        List<com.alibaba.csp.sentinel.slots.block.flow.FlowRule> rules = new ArrayList<com.alibaba.csp.sentinel.slots.block.flow.FlowRule>(oldRules.size());
        if (!this.filterGroup) {
            for (Map.Entry entry : map.entrySet()) {
                for (FlowRule oldRule : (List)entry.getValue()) {
                    rules.add(LegacyRuleConvertUtils.convertFlowRule(oldRule));
                }
            }
            return rules;
        }
        String string = MachineGroupUtil.getGroupNameOfThisMachine();
        for (Map.Entry entry : map.entrySet()) {
            HashSet<String> groupSet = new HashSet<String>();
            for (FlowRule oldRule : (List)entry.getValue()) {
                if (!StringUtil.isNotBlank(oldRule.getGroup())) continue;
                groupSet.add(oldRule.getGroup());
            }
            for (FlowRule oldRule : (List)entry.getValue()) {
                if (!MachineGroupUtil.checkRuleGroup(string, oldRule.getGroup(), groupSet)) continue;
                rules.add(LegacyRuleConvertUtils.convertFlowRule(oldRule));
            }
        }
        if (ruleTransformer != null) {
            rules = ruleTransformer.apply(rules);
        }
        return rules;
    }

    public static void setRuleTransformer(Function<List<com.alibaba.csp.sentinel.slots.block.flow.FlowRule>, List<com.alibaba.csp.sentinel.slots.block.flow.FlowRule>> ruleTransformer) {
        LegacyFlowRuleParser.ruleTransformer = ruleTransformer;
    }
}

