/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.datasource;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.Diamond;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowClusterConfig;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowItem;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.taobao.csp.sentinel.slots.block.flow.HotParamRule;
import com.taobao.csp.sentinel.util.LegacyRuleConvertUtils;
import com.taobao.csp.sentinel.util.MachineGroupUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LegacyParamFlowRuleParser
implements Converter<String, List<ParamFlowRule>> {
    private final String hotItemPrefix;
    private final String diamondGroup;
    private final boolean filterGroup;

    public LegacyParamFlowRuleParser(String hotItemPrefix, String diamondGroup) {
        this(hotItemPrefix, diamondGroup, true);
    }

    public LegacyParamFlowRuleParser(String hotItemPrefix, String diamondGroup, boolean filterGroup) {
        this.hotItemPrefix = hotItemPrefix;
        this.diamondGroup = diamondGroup;
        this.filterGroup = filterGroup;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ParamFlowRule> convert(String source) {
        if (StringUtil.isEmpty(source)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject(source);
        String ruleConf = jsonObject.getObject("data", String.class);
        if (StringUtil.isEmpty(ruleConf)) {
            return null;
        }
        List<HotParamRule> oldRules = JSONObject.parseObject(ruleConf, new TypeReference<List<HotParamRule>>(){}, Feature.IgnoreNotMatch);
        if (oldRules == null) {
            return null;
        }
        HashMap map = new HashMap(16);
        for (HotParamRule hotParamRule : oldRules) {
            void var8_10;
            List list = (List)map.get(hotParamRule.getIdentity());
            if (list == null) {
                ArrayList arrayList = new ArrayList(4);
                map.put(hotParamRule.getIdentity(), arrayList);
            }
            var8_10.add(hotParamRule);
        }
        ArrayList<ParamFlowRule> rules = new ArrayList<ParamFlowRule>(oldRules.size());
        if (!this.filterGroup) {
            for (Map.Entry entry : map.entrySet()) {
                for (HotParamRule oldRule : (List)entry.getValue()) {
                    rules.add(this.fromOldRule(oldRule));
                }
            }
            return rules;
        }
        String string = MachineGroupUtil.getGroupNameOfThisMachine();
        for (Map.Entry entry : map.entrySet()) {
            HashSet<String> groupSet = new HashSet<String>();
            for (HotParamRule oldRule : (List)entry.getValue()) {
                if (!StringUtil.isNotBlank(oldRule.getGroup())) continue;
                groupSet.add(oldRule.getGroup());
            }
            for (HotParamRule oldRule : (List)entry.getValue()) {
                if (!MachineGroupUtil.checkRuleGroup(string, oldRule.getGroup(), groupSet)) continue;
                rules.add(this.fromOldRule(oldRule));
            }
        }
        return rules;
    }

    private ParamFlowRule fromOldRule(HotParamRule oldRule) {
        ParamFlowRule rule = LegacyRuleConvertUtils.convertParamFlowRuleExceptHotItems(oldRule);
        ParamFlowClusterConfig config = new ParamFlowClusterConfig();
        config.setFlowId(oldRule.getIdx());
        config.setSampleCount(oldRule.getSampleCount());
        if (oldRule.isCluster()) {
            if (oldRule.getClusterThresholdType() != null) {
                config.setThresholdType(oldRule.getClusterThresholdType());
            }
            if (oldRule.getClusterFailFallback() != null) {
                config.setFallbackToLocalWhenFail(oldRule.getClusterFailFallback());
            }
        }
        rule.setClusterConfig(config);
        rule.setParamFlowItemList(this.getHotItemsFromDiamond(oldRule.getId()));
        return rule;
    }

    private List<ParamFlowItem> getHotItemsFromDiamond(String ruleId) {
        ArrayList<ParamFlowItem> items = new ArrayList<ParamFlowItem>();
        try {
            String source = Diamond.getConfig(this.hotItemPrefix + ruleId, this.diamondGroup, 3000L);
            RecordLog.info("[ParamFlowRuleConverter] Receive hotItems for ruleId <{0}>: " + source, ruleId);
            if (StringUtil.isEmpty(source)) {
                return items;
            }
            JSONObject jsonObject = JSONObject.parseObject(source);
            JSONObject jsonObject2 = jsonObject.getJSONObject("data");
            if (jsonObject2 == null) {
                return items;
            }
            String itemsString = jsonObject2.getString("items");
            List<ParamFlowItem> items2 = JSON.parseObject(itemsString, new TypeReference<List<ParamFlowItem>>(){}, Feature.IgnoreNotMatch);
            if (items2 != null) {
                return items2;
            }
        }
        catch (Exception e) {
            RecordLog.warn("[ParamFlowRuleConverter] Failed to get or parse hotItems", e);
        }
        return items;
    }
}

