/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.datasource;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.TypeReference;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.parser.Feature;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.taobao.csp.sentinel.slots.system.SystemRule;
import com.taobao.csp.sentinel.util.LegacyRuleConvertUtils;
import com.taobao.csp.sentinel.util.MachineGroupUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class LegacySystemRuleParser
implements Converter<String, List<com.alibaba.csp.sentinel.slots.system.SystemRule>> {
    @Override
    public List<com.alibaba.csp.sentinel.slots.system.SystemRule> convert(String source) {
        if (StringUtil.isEmpty(source)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject(source);
        String ruleConf = jsonObject.getObject("data", String.class);
        if (StringUtil.isEmpty(ruleConf)) {
            return null;
        }
        List<SystemRule> oldRules = JSONObject.parseObject(ruleConf, new TypeReference<List<SystemRule>>(){}, Feature.IgnoreNotMatch);
        if (oldRules == null) {
            return null;
        }
        ArrayList<com.alibaba.csp.sentinel.slots.system.SystemRule> rules = new ArrayList<com.alibaba.csp.sentinel.slots.system.SystemRule>(oldRules.size());
        String machineGroup = MachineGroupUtil.getGroupNameOfThisMachine();
        HashSet<String> groupSet = new HashSet<String>();
        for (SystemRule oldRule : oldRules) {
            if (!StringUtil.isNotBlank(oldRule.getGroup())) continue;
            groupSet.add(oldRule.getGroup());
        }
        for (SystemRule oldRule : oldRules) {
            if (!MachineGroupUtil.checkRuleGroup(machineGroup, oldRule.getGroup(), groupSet)) continue;
            rules.add(LegacyRuleConvertUtils.convertSystemRule(oldRule));
        }
        return rules;
    }
}

