/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.entrance;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.hsf.SentinelHsfAdapterConfig;
import com.alibaba.csp.sentinel.adapter.hsf.fallback.HsfFallbackRegistry;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.taobao.csp.sentinel.util.MethodUtil;
import com.taobao.hsf.context.RPCContext;
import com.taobao.hsf.util.RequestCtxUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;

@Deprecated
public class LegacyHsfProviderInvocationHandler
implements InvocationHandler {
    public static final String SENTINEL_ORIGIN_KEY = "SENTINEL_ORIGIN";
    private final Object proxyObject;

    public LegacyHsfProviderInvocationHandler(Object proxyObject) {
        this.proxyObject = proxyObject;
    }

    private String resolveOrigin() {
        RPCContext rpcContext = RPCContext.getServerContext();
        String origin = (String)rpcContext.getAttachment(SENTINEL_ORIGIN_KEY);
        if (StringUtil.isBlank(origin)) {
            origin = RequestCtxUtil.getAppNameOfClient();
        }
        if (StringUtil.isBlank(origin)) {
            origin = "";
        }
        return origin;
    }

    private boolean isLocalInvocation() {
        String peerIp = RequestCtxUtil.getClientIp();
        String localIp = HostNameUtil.getIp();
        String consumerApp = RequestCtxUtil.getAppNameOfClient();
        String currentApp = AppNameUtil.getAppName();
        return Objects.equals(peerIp, localIp) && Objects.equals(consumerApp, currentApp);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("toString".equals(method.getName()) || "hashCode".equals(method.getName()) || "equals".equals(method.getName()) || "setClientIp".equals(method.getName())) {
            return method.invoke(this.proxyObject, args);
        }
        if (!SentinelHsfAdapterConfig.isEnableForLocalCalls() && this.isLocalInvocation()) {
            try {
                return method.invoke(this.proxyObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        try {
            Object result;
            String methodName = MethodUtil.getMethodName(method);
            String origin = this.resolveOrigin();
            ContextUtil.enter(methodName, origin);
            interfaceEntry = SphU.entry(method.getDeclaringClass().getName(), 2, EntryType.OUT);
            methodEntry = SphU.entry(methodName, 2, EntryType.IN, args);
            Object object = result = method.invoke(this.proxyObject, args);
            return object;
        }
        catch (BlockException ex) {
            Object origin = HsfFallbackRegistry.getProviderFallback().blocked(null, ex);
            return origin;
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                InvocationTargetException inException = (InvocationTargetException)e;
                e = inException.getTargetException();
            }
            Tracer.traceEntry(e, interfaceEntry);
            Tracer.traceEntry(e, methodEntry);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, args);
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
            ContextUtil.exit();
        }
    }
}

