/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.util;

import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.taobao.csp.sentinel.slots.block.authority.AuthorityRule;
import com.taobao.csp.sentinel.slots.block.degrade.DegrateRule;
import com.taobao.csp.sentinel.slots.block.flow.FlowRule;
import com.taobao.csp.sentinel.slots.block.flow.HotParamRule;
import com.taobao.csp.sentinel.slots.system.SystemRule;

public final class LegacyRuleConvertUtils {
    public static com.alibaba.csp.sentinel.slots.block.flow.FlowRule convertFlowRule(FlowRule oldRule) {
        com.alibaba.csp.sentinel.slots.block.flow.FlowRule rule = new com.alibaba.csp.sentinel.slots.block.flow.FlowRule();
        rule.setResource(oldRule.getIdentity());
        rule.setLimitApp(oldRule.getLimit_app());
        rule.setGrade(oldRule.getGrade());
        rule.setCount(oldRule.getCount());
        rule.setStrategy(oldRule.getStrategy());
        rule.setRefResource(oldRule.getRef_identity());
        rule.setControlBehavior(oldRule.getControlBehavior());
        rule.setWarmUpPeriodSec(oldRule.getWarmUpPeriodSec());
        rule.setMaxQueueingTimeMs(oldRule.getMaxQueueingTimeMs());
        rule.setClusterMode(oldRule.isCluster());
        ClusterFlowConfig config = new ClusterFlowConfig();
        config.setFlowId(oldRule.getId());
        config.setSampleCount(oldRule.getSampleCount());
        if (oldRule.isCluster()) {
            if (oldRule.getClusterFallbackCount() != null) {
                config.setFallbackThreshold(oldRule.getClusterFallbackCount());
            }
            if (oldRule.getClusterFailFallback() != null) {
                config.setFallbackToLocalWhenFail(oldRule.getClusterFailFallback());
            }
            if (oldRule.getClusterThresholdType() != null) {
                config.setThresholdType(oldRule.getClusterThresholdType());
            }
            if (oldRule.getAdjustFallbackThresholdEnabled() != null) {
                config.setAutoAdjustFallbackThresholdEnabled(oldRule.getAdjustFallbackThresholdEnabled());
            }
            if (oldRule.getClusterFailFallback() != null) {
                config.setFallbackThresholdAdjustMargin(oldRule.getFallbackThresholdAdjustMargin());
            }
        }
        rule.setClusterConfig(config);
        return rule;
    }

    public static DegradeRule convertDegradeRule(DegrateRule oldRule) {
        DegradeRule rule = new DegradeRule();
        rule.setResource(oldRule.getIdentity());
        rule.setLimitApp(oldRule.getLimit_app());
        if (oldRule.getStrategy() == 1) {
            rule.setGrade(2);
        } else if (oldRule.getStrategy() == 2) {
            rule.setGrade(1);
        } else {
            rule.setGrade(oldRule.getStrategy());
        }
        rule.setCount(oldRule.getDegrade_rt());
        rule.setTimeWindow(oldRule.getTime_window());
        if (oldRule.getMinRequestAmount() != null) {
            rule.setMinRequestAmount(oldRule.getMinRequestAmount());
        }
        if (oldRule.getSlowRatioThreshold() != null) {
            rule.setSlowRatioThreshold(oldRule.getSlowRatioThreshold());
        }
        if (oldRule.getStatIntervalMs() != null) {
            rule.setStatIntervalMs(oldRule.getStatIntervalMs());
        } else if (rule.getGrade() == 2) {
            rule.setStatIntervalMs(60000);
        }
        return rule;
    }

    public static ParamFlowRule convertParamFlowRuleExceptHotItems(HotParamRule oldRule) {
        ParamFlowRule rule = new ParamFlowRule();
        rule.setResource(oldRule.getIdentity());
        rule.setLimitApp(oldRule.getLimitApp());
        rule.setGrade(oldRule.getBlockGrade());
        rule.setParamIdx(oldRule.getParamIdx());
        rule.setCount(oldRule.getBlockCount());
        rule.setClusterMode(oldRule.isCluster());
        if (oldRule.getDurationInSec() != null) {
            rule.setDurationInSec(oldRule.getDurationInSec().intValue());
        }
        return rule;
    }

    public static com.alibaba.csp.sentinel.slots.system.SystemRule convertSystemRule(SystemRule oldRule) {
        com.alibaba.csp.sentinel.slots.system.SystemRule rule = new com.alibaba.csp.sentinel.slots.system.SystemRule();
        rule.setHighestSystemLoad(oldRule.getHighestSystemLoad());
        rule.setQps(oldRule.getQps());
        rule.setAvgRt(oldRule.getAvgRt());
        rule.setMaxThread(oldRule.getMaxThread());
        rule.setHighestCpuUsage(oldRule.getHighestCpuUsage());
        return rule;
    }

    public static com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule convertAuthorityRule(AuthorityRule oldRule) {
        com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule rule = new com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule();
        rule.setResource(oldRule.getIdentity());
        rule.setLimitApp(oldRule.getLimit_app());
        rule.setStrategy(oldRule.getStrategy());
        return rule;
    }

    private LegacyRuleConvertUtils() {
    }
}

