/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.util;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.HostNameUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Set;

public final class MachineGroupUtil {
    public static final String OTHER = "other";
    public static final String ASI_APP_GROUP_ENV = "SIGMA_APP_GROUP";

    public static boolean checkRuleGroup(String machineGroup, String ruleGroup, Set<String> rulesGroupSet) {
        if (StringUtil.isBlank(ruleGroup)) {
            return true;
        }
        if (StringUtil.isBlank(machineGroup)) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase(ruleGroup, OTHER)) {
            return !rulesGroupSet.contains(machineGroup);
        }
        return StringUtil.equalsIgnoreCase(machineGroup, ruleGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resolveGroupNameFromArmoryScript() {
        try {
            Process exec = Runtime.getRuntime().exec("armory --fields nodegroup -l -i " + HostNameUtil.getIp());
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(exec.getInputStream()));
                String line = reader.readLine();
                if (StringUtil.isBlank(line)) {
                    String string2 = null;
                    return string2;
                }
                String string = line.trim();
                return string;
            }
            catch (Throwable e) {
                RecordLog.warn("[MachineGroupUtil] Failed to resolve GroupName From ArmoryScript.", e);
                return null;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        RecordLog.warn("[MachineGroupUtil] Failed to close bufferedReader", e);
                    }
                }
            }
        }
        catch (Exception ex) {
            RecordLog.warn("[MachineGroupUtil] Failed to resolve appGroup from `armory` command. Please check whether the `armory` command has been installed.", new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resolveGroupNameFromHostinfo() {
        try {
            Process exec = Runtime.getRuntime().exec("hostinfo -a -f json");
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(exec.getInputStream()));
                String line = reader.readLine();
                String string = MachineGroupUtil.parseGroupNameFromHostinfo(line);
                return string;
            }
            catch (Throwable e) {
                RecordLog.warn("[MachineGroupUtil] Failed to resolve GroupName From Hostinfo.", e);
                return null;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        RecordLog.warn("[MachineGroupUtil] Failed to close bufferedReader", e);
                    }
                }
            }
        }
        catch (Throwable e3) {
            RecordLog.warn("[MachineGroupUtil] Failed to resolve the appGroup. Please check whether the `hostinfo` command has been installed.", new Object[0]);
        }
        return null;
    }

    public static String getGroupNameOfThisMachine() {
        String group = MachineGroupUtil.resolveGroupNameFromHostinfo();
        if (StringUtil.isBlank(group)) {
            group = MachineGroupUtil.parseAppGroupFromAsiEnv();
            RecordLog.info("[MachineGroupUtil] Retrieving the appGroup from SIGMA_APP_GROUP env: " + group, new Object[0]);
        }
        if (StringUtil.isBlank(group)) {
            group = MachineGroupUtil.resolveGroupNameFromArmoryScript();
            RecordLog.info("[MachineGroupUtil] Retrieving the appGroup from `armory` command: " + group, new Object[0]);
        }
        RecordLog.info("[MachineGroupUtil] Current machine group resolved: " + group, new Object[0]);
        return group;
    }

    private static String parseAppGroupFromAsiEnv() {
        return System.getenv(ASI_APP_GROUP_ENV);
    }

    private static String parseGroupNameFromHostinfo(String line) {
        if (StringUtil.isBlank(line)) {
            return null;
        }
        try {
            JSONObject object = JSON.parseObject(line);
            JSONObject cmdb = JSON.parseObject(object.getString("cmdb"));
            if (cmdb == null) {
                RecordLog.warn("[MachineGroupUtil] Failed to resolve the appGroup, hostinfo cmdb data not ready (null)", new Object[0]);
                return null;
            }
            return cmdb.getString("appGroup");
        }
        catch (Throwable t) {
            RecordLog.warn("[MachineGroupUtil] Failed to resolve the appGroup, hostinfo data format error, need json but: " + line, t);
            return null;
        }
    }
}

