/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.csp.sentinel.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodUtil {
    private static Map<Method, Method> methodMap = new ConcurrentHashMap<Method, Method>();
    private static Map<Method, String> methodNameMap = new HashMap<Method, String>();
    private static Object lock = new Object();

    public static Method getInterfaceMethod(Method impMethod) {
        Class<?>[] interS;
        if (impMethod == null) {
            return null;
        }
        Method method = methodMap.get(impMethod);
        if (method != null) {
            return method;
        }
        for (Class<?> inter : interS = impMethod.getDeclaringClass().getInterfaces()) {
            try {
                method = inter.getMethod(impMethod.getName(), impMethod.getParameterTypes());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (method != null) {
            methodMap.put(impMethod, method);
        } else {
            method = impMethod;
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMethodName(Method method) {
        String methodName = methodNameMap.get(method);
        if (methodName == null) {
            Object object = lock;
            synchronized (object) {
                methodName = methodNameMap.get(method);
                if (methodName == null) {
                    StringBuilder sb = new StringBuilder();
                    String className = method.getDeclaringClass().getName();
                    String mehodName = method.getName();
                    Class<?>[] params = method.getParameterTypes();
                    sb.append(className).append(":").append(mehodName);
                    sb.append("(");
                    int paramPos = 0;
                    for (Class<?> claz : params) {
                        sb.append(claz.getName());
                        if (++paramPos >= params.length) continue;
                        sb.append(",");
                    }
                    sb.append(")");
                    methodName = sb.toString();
                    HashMap<Method, String> newMap = new HashMap<Method, String>();
                    newMap.putAll(methodNameMap);
                    newMap.put(method, methodName);
                    methodNameMap = newMap;
                }
            }
        }
        return methodName;
    }

    public static Class<?>[] getAllInterfaces(Class<?> cls) {
        ArrayList list = new ArrayList();
        if (cls == null) {
            return list.toArray(new Class[0]);
        }
        while (cls != null) {
            Class<?>[] interfaces = cls.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?>[] superInterfaces;
                if (!list.contains(interfaces[i])) {
                    list.add(interfaces[i]);
                }
                for (Class<?> intface : superInterfaces = MethodUtil.getAllInterfaces(interfaces[i])) {
                    if (list.contains(intface)) continue;
                    list.add(intface);
                }
            }
            cls = cls.getSuperclass();
        }
        return list.toArray(new Class[0]);
    }
}

