/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.protocol.okhttp;

import com.alibaba.dashscope.protocol.ClientOptions;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClientFactory.class);

    private OkHttpClientFactory() {
        if (Holder.INSTANCE != null) {
            throw new IllegalStateException();
        }
    }

    public static OkHttpClient getOkHttpClient() {
        return Holder.INSTANCE;
    }

    public static OkHttpClient getNewOkHttpClient(ClientOptions options) {
        OkHttpClient.Builder builder = Holder.INSTANCE.newBuilder();
        builder.connectTimeout(options.getConnectTimeout()).readTimeout(options.getReadTimeout()).writeTimeout(options.getWriteTimeout());
        return builder.build();
    }

    private static class Holder {
        private static final OkHttpClient INSTANCE = Holder.createInstance();

        private Holder() {
        }

        private static OkHttpClient createInstance() {
            Object defaultOptions = ClientOptions.builder().build();
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.valueOf((String)((ClientOptions)defaultOptions).getNetworkLoggingLevel()));
            Dispatcher dispatcher = new Dispatcher();
            if (dispatcher.getMaxRequests() < ((ClientOptions)defaultOptions).getConnectionPoolSize()) {
                dispatcher.setMaxRequests(((ClientOptions)defaultOptions).getConnectionPoolSize().intValue());
                dispatcher.setMaxRequestsPerHost(((ClientOptions)defaultOptions).getConnectionPoolSize().intValue());
            }
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            clientBuilder.connectTimeout(((ClientOptions)defaultOptions).getConnectTimeout()).readTimeout(((ClientOptions)defaultOptions).getReadTimeout()).writeTimeout(((ClientOptions)defaultOptions).getWriteTimeout()).addInterceptor((Interceptor)logging).dispatcher(dispatcher).protocols(Collections.singletonList(Protocol.HTTP_1_1)).connectionPool(new ConnectionPool(((ClientOptions)defaultOptions).getConnectionPoolSize().intValue(), ((ClientOptions)defaultOptions).getConnectionIdelTimeout().getSeconds(), TimeUnit.SECONDS));
            return clientBuilder.build();
        }
    }
}

